/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.Stack;

public class StandardStack<T>
implements Stack<T> {
    private LinkedList<T> internalStack = new LinkedList();

    public StandardStack() {
    }

    public StandardStack(T initial) {
        this.internalStack.add(initial);
    }

    @Override
    public void push(T newCurrent) {
        this.internalStack.addFirst(newCurrent);
    }

    @Override
    public T pop() {
        return this.internalStack.removeFirst();
    }

    @Override
    public T getCurrent() {
        return this.internalStack.peek();
    }

    @Override
    public T getPrevious() {
        if (this.internalStack.size() < 2) {
            return null;
        }
        return this.internalStack.get(this.internalStack.size() - 2);
    }

    @Override
    public int depth() {
        return this.internalStack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalStack.isEmpty();
    }

    @Override
    public void clear() {
        this.internalStack.clear();
    }

    @Override
    public void visitCurrentFirst(Consumer<T> action) {
        this.internalStack.forEach(action);
    }

    @Override
    public <X> X findCurrentFirst(Function<T, X> function) {
        for (Object t : this.internalStack) {
            X result = function.apply(t);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

