/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyConfiguration;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyInterceptor;
import org.hibernate.proxy.pojo.bytebuddy.SerializableProxy;
import org.hibernate.type.CompositeType;

public class ByteBuddyProxyFactory
implements ProxyFactory,
Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ByteBuddyProxyFactory.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private Class persistentClass;
    private String entityName;
    private Class[] interfaces;
    private Method getIdentifierMethod;
    private Method setIdentifierMethod;
    private CompositeType componentIdType;
    private boolean overridesEquals;
    private Class proxyClass;

    @Override
    public void postInstantiate(String entityName, Class persistentClass, Set<Class> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.interfaces = this.toArray(interfaces);
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.componentIdType = componentIdType;
        this.overridesEquals = ReflectHelper.overridesEquals(persistentClass);
        this.proxyClass = ByteBuddyProxyFactory.buildProxy(persistentClass, this.interfaces);
    }

    private Class[] toArray(Set<Class> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class buildProxy(final Class persistentClass, final Class[] interfaces) {
        HashSet<Class> key = new HashSet<Class>();
        if (interfaces.length == 1) {
            key.add(persistentClass);
        }
        key.addAll(Arrays.asList(interfaces));
        return CACHE.findOrInsert(persistentClass.getClassLoader(), (Object)new TypeCache.SimpleKey(key), new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return new ByteBuddy().with(TypeValidation.DISABLED).with((NamingStrategy)new NamingStrategy.SuffixingRandom("HibernateProxy")).subclass(interfaces.length == 1 ? persistentClass : Object.class, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).implement((Type[])interfaces).method((ElementMatcher)ElementMatchers.isVirtual().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isFinalizer()))).intercept((Implementation)MethodDelegation.to(ProxyConfiguration.InterceptorDispatcher.class)).method((ElementMatcher)ElementMatchers.nameStartsWith((String)"$$_hibernate_").and((ElementMatcher)ElementMatchers.isVirtual())).intercept((Implementation)SuperMethodCall.INSTANCE).defineField("$$_hibernate_interceptor", ProxyConfiguration.Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)FieldAccessor.ofField((String)"$$_hibernate_interceptor").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make().load(persistentClass.getClassLoader()).getLoaded();
            }
        }, (Object)persistentClass);
    }

    @Override
    public HibernateProxy getProxy(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(this.entityName, this.persistentClass, this.interfaces, id, this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType, session, this.overridesEquals);
        try {
            HibernateProxy proxy = (HibernateProxy)this.proxyClass.newInstance();
            ((ProxyConfiguration)((Object)proxy)).$$_hibernate_set_interceptor(interceptor);
            return proxy;
        }
        catch (Throwable t) {
            LOG.error(LOG.bytecodeEnhancementFailed(this.entityName), t);
            throw new HibernateException(LOG.bytecodeEnhancementFailed(this.entityName), t);
        }
    }

    public static HibernateProxy deserializeProxy(SerializableProxy serializableProxy) {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(serializableProxy.getEntityName(), serializableProxy.getPersistentClass(), serializableProxy.getInterfaces(), serializableProxy.getId(), ByteBuddyProxyFactory.resolveIdGetterMethod(serializableProxy), ByteBuddyProxyFactory.resolveIdSetterMethod(serializableProxy), serializableProxy.getComponentIdType(), null, ReflectHelper.overridesEquals(serializableProxy.getPersistentClass()));
        try {
            Class proxyClass = ByteBuddyProxyFactory.buildProxy(serializableProxy.getPersistentClass(), serializableProxy.getInterfaces());
            HibernateProxy proxy = (HibernateProxy)proxyClass.newInstance();
            ((ProxyConfiguration)((Object)proxy)).$$_hibernate_set_interceptor(interceptor);
            return proxy;
        }
        catch (Throwable t) {
            String message = LOG.bytecodeEnhancementFailed(serializableProxy.getEntityName());
            LOG.error(message, t);
            throw new HibernateException(message, t);
        }
    }

    private static Method resolveIdGetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierGetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierGetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierGetterMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id getter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierGetterMethodName(), serializableProxy.getIdentifierGetterMethodClass()));
        }
    }

    private static Method resolveIdSetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierSetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierSetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodParams());
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id setter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodClass()));
        }
    }
}

