/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.internal.expression;

import java.io.Serializable;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.ParameterRegistry;
import org.hibernate.query.criteria.internal.compile.ExplicitParameterInfo;
import org.hibernate.query.criteria.internal.compile.RenderingContext;
import org.hibernate.query.criteria.internal.expression.ExpressionImpl;
import org.hibernate.type.Type;

public class ParameterExpressionImpl<T>
extends ExpressionImpl<T>
implements ParameterExpression<T>,
QueryParameter<T>,
Serializable {
    private final String name;
    private final Integer position;
    private final Type expectedType;

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, String name, Type expectedType) {
        super(criteriaBuilder, javaType);
        this.name = name;
        this.position = null;
        this.expectedType = expectedType;
    }

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Integer position, Type expectedType) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.position = position;
        this.expectedType = expectedType;
    }

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Type expectedType) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.position = null;
        this.expectedType = expectedType;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        registry.registerParameter(this);
    }

    @Override
    public String render(RenderingContext renderingContext) {
        ExplicitParameterInfo parameterInfo = renderingContext.registerExplicitParameter(this);
        return parameterInfo.render();
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    @Override
    public Type getType() {
        return this.expectedType;
    }

    @Override
    public boolean isJpaPositionalParameter() {
        return true;
    }
}

