/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.spi.HydratedCompoundValueHandler;
import org.hibernate.persister.walking.internal.Helper;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AssociationKey;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.tuple.BaselineAttributeInformation;
import org.hibernate.tuple.component.AbstractCompositeBasedAttribute;
import org.hibernate.tuple.component.AbstractCompositionDefinition;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;

public class CompositeBasedAssociationAttribute
extends AbstractCompositeBasedAttribute
implements AssociationAttributeDefinition {
    private final AssociationKey associationKey;
    private Joinable joinable;
    private HydratedCompoundValueHandler hydratedCompoundValueHandler;

    public CompositeBasedAssociationAttribute(AbstractCompositionDefinition source, SessionFactoryImplementor factory, int attributeNumber, String attributeName, AssociationType attributeType, BaselineAttributeInformation baselineInfo, int ownerAttributeNumber, AssociationKey associationKey) {
        super(source, factory, attributeNumber, attributeName, attributeType, baselineInfo, ownerAttributeNumber);
        this.associationKey = associationKey;
    }

    @Override
    public AssociationType getType() {
        return (AssociationType)super.getType();
    }

    protected Joinable getJoinable() {
        if (this.joinable == null) {
            this.joinable = this.getType().getAssociatedJoinable(this.sessionFactory());
        }
        return this.joinable;
    }

    @Override
    public AssociationKey getAssociationKey() {
        return this.associationKey;
    }

    @Override
    public boolean isCollection() {
        return this.getJoinable().isCollection();
    }

    @Override
    public EntityDefinition toEntityDefinition() {
        if (this.isCollection()) {
            throw new IllegalStateException("Cannot treat collection attribute as entity type");
        }
        return (EntityPersister)((Object)this.getJoinable());
    }

    @Override
    public CollectionDefinition toCollectionDefinition() {
        if (this.isCollection()) {
            throw new IllegalStateException("Cannot treat entity attribute as collection type");
        }
        return (CollectionPersister)((Object)this.getJoinable());
    }

    @Override
    public FetchStrategy determineFetchPlan(LoadQueryInfluencers loadQueryInfluencers, PropertyPath propertyPath) {
        EntityPersister owningPersister = this.locateOwningPersister();
        FetchStyle style = this.determineFetchStyleByProfile(loadQueryInfluencers, owningPersister, propertyPath, this.ownerAttributeNumber());
        if (style == null) {
            style = this.determineFetchStyleByMetadata(this.getSource().getType().getFetchMode(this.attributeNumber()), this.getType());
        }
        return new FetchStrategy(this.determineFetchTiming(style), style);
    }

    protected FetchStyle determineFetchStyleByProfile(LoadQueryInfluencers loadQueryInfluencers, EntityPersister owningPersister, PropertyPath propertyPath, int ownerAttributeNumber) {
        return Helper.determineFetchStyleByProfile(loadQueryInfluencers, owningPersister, propertyPath, ownerAttributeNumber);
    }

    protected FetchStyle determineFetchStyleByMetadata(FetchMode fetchMode, AssociationType type) {
        return Helper.determineFetchStyleByMetadata(fetchMode, type, this.sessionFactory());
    }

    private FetchTiming determineFetchTiming(FetchStyle style) {
        return Helper.determineFetchTiming(style, this.getType(), this.sessionFactory());
    }

    private EntityPersister locateOwningPersister() {
        return this.getSource().locateOwningPersister();
    }

    @Override
    public CascadeStyle determineCascadeStyle() {
        CompositeType compositeType = (CompositeType)this.locateOwningPersister().getPropertyType(this.getName());
        return compositeType.getCascadeStyle(this.attributeNumber());
    }

    @Override
    public HydratedCompoundValueHandler getHydratedCompoundValueExtractor() {
        if (this.hydratedCompoundValueHandler == null) {
            this.hydratedCompoundValueHandler = new HydratedCompoundValueHandler(){

                @Override
                public Object extract(Object hydratedState) {
                    return ((Object[])hydratedState)[CompositeBasedAssociationAttribute.this.attributeNumber()];
                }

                @Override
                public void inject(Object hydratedState, Object value) {
                    ((Object[])hydratedState)[((CompositeBasedAssociationAttribute)CompositeBasedAssociationAttribute.this).attributeNumber()] = value;
                }
            };
        }
        return this.hydratedCompoundValueHandler;
    }

    @Override
    protected String loggableMetadata() {
        return super.loggableMetadata() + ",association";
    }
}

