/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.internal.LoadPlanBuildingHelper;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.CopyableReturn;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.loader.spi.ResultSetProcessingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;

public class EntityReturn
extends AbstractFetchOwner
implements Return,
EntityReference,
CopyableReturn {
    private final EntityPersister persister;
    private final PropertyPath propertyPath = new PropertyPath();
    private IdentifierDescription identifierDescription;

    public EntityReturn(SessionFactoryImplementor sessionFactory, LockMode lockMode, String entityName) {
        super(sessionFactory, lockMode);
        this.persister = sessionFactory.getEntityPersister(entityName);
    }

    protected EntityReturn(EntityReturn original, CopyContext copyContext) {
        super(original, copyContext);
        this.persister = original.persister;
    }

    @Override
    public LockMode getLockMode() {
        return super.getLockMode();
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.getEntityPersister();
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCollectionFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardEntityFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public CompositeFetch buildCompositeFetch(CompositionDefinition attributeDefinition, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCompositeFetch(this, attributeDefinition, loadPlanBuildingContext);
    }

    @Override
    public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        EntityKey entityKey = context.getDictatedRootEntityKey();
        if (entityKey != null) {
            context.getIdentifierResolutionContext(this).registerEntityKey(entityKey);
            return;
        }
        this.identifierDescription.hydrate(resultSet, context);
        for (Fetch fetch : this.getFetches()) {
            fetch.hydrate(resultSet, context);
        }
    }

    @Override
    public void resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        ResultSetProcessingContext.IdentifierResolutionContext identifierResolutionContext = context.getIdentifierResolutionContext(this);
        EntityKey entityKey = identifierResolutionContext.getEntityKey();
        if (entityKey != null) {
            return;
        }
        entityKey = this.identifierDescription.resolve(resultSet, context);
        identifierResolutionContext.registerEntityKey(entityKey);
        for (Fetch fetch : this.getFetches()) {
            fetch.resolve(resultSet, context);
        }
    }

    @Override
    public Object read(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        Object objectForThisEntityReturn = null;
        for (ResultSetProcessingContext.IdentifierResolutionContext identifierResolutionContext : context.getIdentifierResolutionContexts()) {
            EntityReference entityReference = identifierResolutionContext.getEntityReference();
            EntityKey entityKey = identifierResolutionContext.getEntityKey();
            if (entityKey == null) {
                throw new AssertionFailure("Could not locate resolved EntityKey");
            }
            Object object = context.resolveEntityKey(entityKey, entityReference);
            if (this != entityReference) continue;
            objectForThisEntityReturn = object;
        }
        return objectForThisEntityReturn;
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    public String toString() {
        return "EntityReturn(" + this.persister.getEntityName() + ")";
    }

    @Override
    public EntityReturn makeCopy(CopyContext copyContext) {
        return new EntityReturn(this, copyContext);
    }
}

