/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.internal.LoadPlanBuildingHelper;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchableCollectionIndex;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.type.AssociationType;

public class EntityIndexGraph
extends AbstractPlanNode
implements FetchableCollectionIndex,
EntityReference {
    private final CollectionReference collectionReference;
    private final CollectionPersister collectionPersister;
    private final AssociationType indexType;
    private final EntityPersister indexPersister;
    private final PropertyPath propertyPath;
    private List<Fetch> fetches;
    private IdentifierDescription identifierDescription;

    public EntityIndexGraph(SessionFactoryImplementor sessionFactory, CollectionReference collectionReference, PropertyPath collectionPath) {
        super(sessionFactory);
        this.collectionReference = collectionReference;
        this.collectionPersister = collectionReference.getCollectionPersister();
        this.indexType = (AssociationType)this.collectionPersister.getIndexType();
        this.indexPersister = (EntityPersister)((Object)this.indexType.getAssociatedJoinable(this.sessionFactory()));
        this.propertyPath = collectionPath.append("<index>");
    }

    public EntityIndexGraph(EntityIndexGraph original, CopyContext copyContext) {
        super(original);
        this.collectionReference = original.collectionReference;
        this.collectionPersister = original.collectionReference.getCollectionPersister();
        this.indexType = original.indexType;
        this.indexPersister = original.indexPersister;
        this.propertyPath = original.propertyPath;
        copyContext.getReturnGraphVisitationStrategy().startingFetches(original);
        if (this.fetches == null || this.fetches.size() == 0) {
            this.fetches = Collections.emptyList();
        } else {
            ArrayList<Fetch> fetchesCopy = new ArrayList<Fetch>();
            for (Fetch fetch : this.fetches) {
                fetchesCopy.add(fetch.makeCopy(copyContext, this));
            }
            this.fetches = fetchesCopy;
        }
        copyContext.getReturnGraphVisitationStrategy().finishingFetches(original);
    }

    @Override
    public LockMode getLockMode() {
        return null;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.indexPersister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void addFetch(Fetch fetch) {
        if (this.fetches == null) {
            this.fetches = new ArrayList<Fetch>();
        }
        this.fetches.add(fetch);
    }

    @Override
    public Fetch[] getFetches() {
        return this.fetches == null ? NO_FETCHES : this.fetches.toArray(new Fetch[this.fetches.size()]);
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.indexPersister;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCollectionFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardEntityFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public CompositeFetch buildCompositeFetch(CompositionDefinition attributeDefinition, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCompositeFetch(this, attributeDefinition, loadPlanBuildingContext);
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public EntityIndexGraph makeCopy(CopyContext copyContext) {
        return new EntityIndexGraph(this, copyContext);
    }
}

