/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.WrongClassException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.internal.LoadPlanBuildingHelper;
import org.hibernate.loader.plan.spi.AbstractSingularAttributeFetch;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.loader.spi.ResultSetProcessingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.type.EntityType;

public class EntityFetch
extends AbstractSingularAttributeFetch
implements EntityReference {
    private final EntityType associationType;
    private final EntityPersister persister;
    private IdentifierDescription identifierDescription;

    public EntityFetch(SessionFactoryImplementor sessionFactory, LockMode lockMode, FetchOwner owner, String ownerProperty, FetchStrategy fetchStrategy) {
        super(sessionFactory, lockMode, owner, ownerProperty, fetchStrategy);
        this.associationType = (EntityType)owner.retrieveFetchSourcePersister().getPropertyType(ownerProperty);
        this.persister = sessionFactory.getEntityPersister(this.associationType.getAssociatedEntityName());
    }

    protected EntityFetch(EntityFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext, fetchOwnerCopy);
        this.associationType = original.associationType;
        this.persister = original.persister;
    }

    public EntityType getAssociationType() {
        return this.associationType;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.persister;
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCollectionFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardEntityFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public CompositeFetch buildCompositeFetch(CompositionDefinition attributeDefinition, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCompositeFetch(this, attributeDefinition, loadPlanBuildingContext);
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        EntityKey entityKey = context.getDictatedRootEntityKey();
        if (entityKey != null) {
            context.getIdentifierResolutionContext(this).registerEntityKey(entityKey);
            return;
        }
        this.identifierDescription.hydrate(resultSet, context);
        for (Fetch fetch : this.getFetches()) {
            fetch.hydrate(resultSet, context);
        }
    }

    @Override
    public EntityKey resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        ResultSetProcessingContext.IdentifierResolutionContext identifierResolutionContext = context.getIdentifierResolutionContext(this);
        EntityKey entityKey = identifierResolutionContext.getEntityKey();
        if (entityKey == null) {
            EntityKey ownersEntityKey;
            entityKey = this.identifierDescription.resolve(resultSet, context);
            if (entityKey == null && this.associationType.isOneToOne() && (ownersEntityKey = context.getIdentifierResolutionContext((EntityReference)((Object)this.getOwner())).getEntityKey()) != null) {
                context.getSession().getPersistenceContext().addNullProperty(ownersEntityKey, this.associationType.getPropertyName());
            }
            identifierResolutionContext.registerEntityKey(entityKey);
            for (Fetch fetch : this.getFetches()) {
                fetch.resolve(resultSet, context);
            }
        }
        return entityKey;
    }

    public EntityKey resolveInIdentifier(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        EntityKey entityKey = this.resolve(resultSet, context);
        Object existing = context.getSession().getEntityUsingInterceptor(entityKey);
        if (existing != null) {
            if (!this.persister.isInstance(existing)) {
                throw new WrongClassException("loaded object was of wrong class " + existing.getClass(), entityKey.getIdentifier(), this.persister.getEntityName());
            }
            if (this.getLockMode() != null && this.getLockMode() != LockMode.NONE) {
                boolean isVersionCheckNeeded;
                boolean bl = isVersionCheckNeeded = this.persister.isVersioned() && context.getSession().getPersistenceContext().getEntry(existing).getLockMode().lessThan(this.getLockMode());
                if (isVersionCheckNeeded) {
                    context.checkVersion(resultSet, this.persister, context.getLoadQueryAliasResolutionContext().resolveEntityColumnAliases(this), entityKey, existing);
                    context.getSession().getPersistenceContext().getEntry(existing).setLockMode(this.getLockMode());
                }
            }
        } else {
            String concreteEntityTypeName = context.getConcreteEntityTypeName(resultSet, this.persister, context.getLoadQueryAliasResolutionContext().resolveEntityColumnAliases(this), entityKey);
            Object entityInstance = context.getSession().instantiate(concreteEntityTypeName, entityKey.getIdentifier());
            LockMode acquiredLockMode = this.getLockMode() == LockMode.NONE ? LockMode.READ : this.getLockMode();
            context.loadFromResultSet(resultSet, entityInstance, concreteEntityTypeName, entityKey, context.getLoadQueryAliasResolutionContext().resolveEntityColumnAliases(this), acquiredLockMode, this.persister, this.getFetchStrategy().getTiming() == FetchTiming.IMMEDIATE, this.associationType);
            context.registerHydratedEntity(this.persister, entityKey, entityInstance);
        }
        return entityKey;
    }

    @Override
    public String toString() {
        return "EntityFetch(" + this.getPropertyPath().getFullPath() + " -> " + this.persister.getEntityName() + ")";
    }

    @Override
    public EntityFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingEntityFetch(this);
        EntityFetch copy = new EntityFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().finishingEntityFetch(this);
        return copy;
    }
}

