/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.internal.LoadPlanBuildingHelper;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchableCollectionElement;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.type.AssociationType;

public class EntityElementGraph
extends AbstractPlanNode
implements FetchableCollectionElement,
EntityReference {
    private final CollectionReference collectionReference;
    private final CollectionPersister collectionPersister;
    private final AssociationType elementType;
    private final EntityPersister elementPersister;
    private final PropertyPath propertyPath;
    private List<Fetch> fetches;
    private IdentifierDescription identifierDescription;

    public EntityElementGraph(SessionFactoryImplementor sessionFactory, CollectionReference collectionReference, PropertyPath collectionPath) {
        super(sessionFactory);
        this.collectionReference = collectionReference;
        this.collectionPersister = collectionReference.getCollectionPersister();
        this.elementType = (AssociationType)this.collectionPersister.getElementType();
        this.elementPersister = (EntityPersister)((Object)this.elementType.getAssociatedJoinable(this.sessionFactory()));
        this.propertyPath = collectionPath.append("<elements>");
    }

    public EntityElementGraph(EntityElementGraph original, CopyContext copyContext) {
        super(original);
        this.collectionReference = original.collectionReference;
        this.collectionPersister = original.collectionReference.getCollectionPersister();
        this.elementType = original.elementType;
        this.elementPersister = original.elementPersister;
        this.propertyPath = original.propertyPath;
        copyContext.getReturnGraphVisitationStrategy().startingFetches(original);
        if (this.fetches == null || this.fetches.size() == 0) {
            this.fetches = Collections.emptyList();
        } else {
            ArrayList<Fetch> fetchesCopy = new ArrayList<Fetch>();
            for (Fetch fetch : this.fetches) {
                fetchesCopy.add(fetch.makeCopy(copyContext, this));
            }
            this.fetches = fetchesCopy;
        }
        copyContext.getReturnGraphVisitationStrategy().finishingFetches(original);
    }

    @Override
    public LockMode getLockMode() {
        return null;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.elementPersister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void addFetch(Fetch fetch) {
        if (this.fetches == null) {
            this.fetches = new ArrayList<Fetch>();
        }
        this.fetches.add(fetch);
    }

    @Override
    public Fetch[] getFetches() {
        return this.fetches == null ? NO_FETCHES : this.fetches.toArray(new Fetch[this.fetches.size()]);
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.elementPersister;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCollectionFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardEntityFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public CompositeFetch buildCompositeFetch(CompositionDefinition attributeDefinition, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCompositeFetch(this, attributeDefinition, loadPlanBuildingContext);
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public EntityElementGraph makeCopy(CopyContext copyContext) {
        return new EntityElementGraph(this, copyContext);
    }

    public String toString() {
        return "EntityElementGraph(collection=" + this.collectionPersister.getRole() + ", type=" + this.elementPersister.getEntityName() + ")";
    }
}

