/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;

public abstract class AbstractFetchOwner
extends AbstractPlanNode
implements FetchOwner {
    private final LockMode lockMode;
    private List<Fetch> fetches;

    public AbstractFetchOwner(SessionFactoryImplementor factory, LockMode lockMode) {
        super(factory);
        this.lockMode = lockMode;
        this.validate();
    }

    private void validate() {
    }

    protected AbstractFetchOwner(AbstractFetchOwner original, CopyContext copyContext) {
        super(original);
        this.lockMode = original.lockMode;
        this.validate();
        copyContext.getReturnGraphVisitationStrategy().startingFetches(original);
        if (this.fetches == null || this.fetches.size() == 0) {
            this.fetches = Collections.emptyList();
        } else {
            ArrayList<Fetch> fetchesCopy = new ArrayList<Fetch>();
            for (Fetch fetch : this.fetches) {
                fetchesCopy.add(fetch.makeCopy(copyContext, this));
            }
            this.fetches = fetchesCopy;
        }
        copyContext.getReturnGraphVisitationStrategy().finishingFetches(original);
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public void addFetch(Fetch fetch) {
        if (fetch.getOwner() != this) {
            throw new IllegalArgumentException("Fetch and owner did not match");
        }
        if (this.fetches == null) {
            this.fetches = new ArrayList<Fetch>();
        }
        this.fetches.add(fetch);
    }

    @Override
    public Fetch[] getFetches() {
        return this.fetches == null ? NO_FETCHES : this.fetches.toArray(new Fetch[this.fetches.size()]);
    }
}

