/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.publish.auth.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.build.gradle.publish.auth.maven.Credentials;
import org.hibernate.build.gradle.publish.auth.maven.CredentialsProvider;
import org.hibernate.build.gradle.publish.auth.maven.DomHelper;
import org.hibernate.build.gradle.publish.auth.maven.PasswordReader;
import org.hibernate.build.gradle.publish.auth.maven.PasswordReaderFactory;
import org.hibernate.build.gradle.publish.auth.maven.PathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SettingsXmlCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(SettingsXmlCredentialsProvider.class);
    public static final SettingsXmlCredentialsProvider INSTANCE = new SettingsXmlCredentialsProvider();
    public static final String SETTINGS_LOCATION_OVERRIDE = "maven.settings";
    private final ConcurrentHashMap<String, Credentials> credentialsByRepoIdMap;

    private SettingsXmlCredentialsProvider() {
        File settingsFile = this.determineSettingsFileLocation();
        this.credentialsByRepoIdMap = this.extractCredentialsFromSettings(settingsFile);
    }

    private File determineSettingsFileLocation() {
        String defaultLocation = "~/.m2/settings.xml";
        String location = System.getProperty(SETTINGS_LOCATION_OVERRIDE, "~/.m2/settings.xml");
        return new File(PathHelper.normalizePath(location));
    }

    private ConcurrentHashMap<String, Credentials> extractCredentialsFromSettings(File settingsFile) {
        ConcurrentHashMap<String, Credentials> byIdMap = new ConcurrentHashMap<String, Credentials>();
        if (!settingsFile.exists()) {
            log.warn("Maven settings.xml file did not exist : " + settingsFile.getAbsolutePath());
            return byIdMap;
        }
        PasswordReader passwordReader = PasswordReaderFactory.INSTANCE.determinePasswordReader();
        try {
            SAXReader saxReader = this.buildSAXReader();
            InputSource inputSource = new InputSource(new FileInputStream(settingsFile));
            try {
                Iterator<Element> serverIterator = this.seekServerElements(saxReader.read(inputSource));
                while (serverIterator.hasNext()) {
                    Element serverElement = serverIterator.next();
                    String id = DomHelper.extractValue(serverElement.element("id"));
                    if (id == null) continue;
                    log.debug("Adding credentials for server : " + id);
                    Credentials authentication = this.extractCredentials(serverElement, passwordReader);
                    byIdMap.put(id, authentication);
                }
            }
            catch (DocumentException e) {
                log.error("Error reading Maven settings.xml", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Unable to locate Maven settings.xml");
        }
        return byIdMap;
    }

    private SAXReader buildSAXReader() {
        SAXReader saxReader = new SAXReader(new DocumentFactory());
        saxReader.setMergeAdjacentText(true);
        return saxReader;
    }

    private Credentials extractCredentials(Element serverElement, PasswordReader passwordReader) {
        Credentials authentication = new Credentials();
        authentication.setUserName(DomHelper.extractValue(serverElement.element("username")));
        authentication.setPassword(passwordReader.readPassword(serverElement.element("password")));
        authentication.setPrivateKey(DomHelper.extractValue(serverElement.element("privateKey")));
        authentication.setPassphrase(DomHelper.extractValue(serverElement.element("passphrase")));
        return authentication;
    }

    private Iterator<Element> seekServerElements(Document document) {
        Element serversElement;
        Element settingsElement = document.getRootElement();
        if (settingsElement != null && (serversElement = settingsElement.element("servers")) != null) {
            return serversElement.elementIterator("server");
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public Credentials determineAuthentication(String repositoryId) {
        return this.credentialsByRepoIdMap.get(repositoryId);
    }
}

