/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.enterprise;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.runtime.EngineCacheSupport;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public abstract class AbstractEngineCacheSupport
implements EngineCacheSupport {
    protected static final String aw = "Policy to use to to force compilation for executed call targets before persisting the engine. Possible values are:%n  - 'none':     No compilations will be persisted and existing compilations will be invalidated.%n  - 'compiled': No compilations will be forced but finished compilations will be persisted.%n  - 'hot':      (default) All started compilations will be completed and then persisted. %n  - 'aot':      All started and AOT compilable roots will be forced to compile and persisted.%n  - 'executed': All executed and all AOT compilable roots will be forced to compile.";
    protected static final String ax = "none|compiled|hot|aot|executed";

    protected abstract OptionKey<Boolean> E();

    protected final void a(EngineData engineData, String string, Object ... objectArray) {
        if (((Boolean)engineData.getEngineOptions().get(this.E())).booleanValue()) {
            engineData.getLogger("engine").info("[cache] " + String.format(string, objectArray));
        }
    }

    protected final void a(OptionValues optionValues, Function<String, TruffleLogger> function, String string, Object ... objectArray) {
        if (((Boolean)optionValues.get(this.E())).booleanValue()) {
            function.apply("engine").info("[cache] " + String.format(string, objectArray));
        }
    }

    protected final Object a(EngineData engineData, a a2, boolean bl, boolean bl2) {
        Collection collection = engineData.getCallTargets();
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (optimizedCallTarget.engine == engineData) continue;
            throw new IllegalStateException("CallTargets from different engines cannot be compiled together.");
        }
        List<OptimizedCallTarget> list = this.a(engineData, (Collection<OptimizedCallTarget>)collection, a2);
        if (bl2) {
            engineData.preinitializeContext();
        }
        engineData.finalizeStore();
        if (list != null && !list.isEmpty()) {
            this.a(engineData, (Collection<OptimizedCallTarget>)list, bl);
        }
        return engineData.getPolyglotEngine();
    }

    private void a(EngineData engineData, Collection<OptimizedCallTarget> collection, boolean bl) {
        this.a(engineData, "Force compiling %s roots for engine caching.", collection.size());
        ArrayList<OptimizedCallTarget> arrayList = new ArrayList<OptimizedCallTarget>();
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (optimizedCallTarget.isValid()) continue;
            if (!optimizedCallTarget.isInitialized()) {
                throw new AssertionError((Object)"Should not reach here.");
            }
            boolean bl2 = optimizedCallTarget.compile(bl);
            if (bl2) continue;
            arrayList.add(optimizedCallTarget);
        }
        for (OptimizedCallTarget optimizedCallTarget : arrayList) {
            try {
                OptimizedTruffleRuntime.getRuntime().waitForCompilation(optimizedCallTarget, Long.MAX_VALUE);
            }
            catch (CancellationException cancellationException) {
                break;
            }
            catch (ExecutionException | TimeoutException exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    private List<OptimizedCallTarget> a(EngineData engineData, Collection<OptimizedCallTarget> collection, a a2) throws AssertionError {
        List<OptimizedCallTarget> list;
        this.a(engineData, "Force compile targets mode: %s", new Object[]{a2});
        switch (a2.ordinal()) {
            case 4: {
                this.a(engineData, collection);
                this.b(engineData, collection);
                list = null;
                break;
            }
            case 3: {
                this.a(engineData, collection);
                list = null;
                break;
            }
            case 2: {
                AbstractEngineCacheSupport.b(collection);
                list = AbstractEngineCacheSupport.a(collection);
                list.removeIf(optimizedCallTarget -> !optimizedCallTarget.isInitialized() || !optimizedCallTarget.shouldCompile());
                break;
            }
            case 1: {
                AbstractEngineCacheSupport.b(collection);
                list = AbstractEngineCacheSupport.a(collection);
                list.removeIf(optimizedCallTarget -> optimizedCallTarget.isInitialized() && !optimizedCallTarget.shouldCompile());
                AbstractEngineCacheSupport.a(engineData, list, true);
                break;
            }
            case 0: {
                AbstractEngineCacheSupport.b(collection);
                list = AbstractEngineCacheSupport.a(collection);
                AbstractEngineCacheSupport.a(engineData, list, false);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid compile mode.");
            }
        }
        return list;
    }

    private static List<OptimizedCallTarget> a(Collection<OptimizedCallTarget> collection) {
        AbstractEngineCacheSupport.c(collection);
        return AbstractEngineCacheSupport.d(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(EngineData engineData, List<OptimizedCallTarget> list, boolean bl) {
        TruffleLanguage truffleLanguage = null;
        Object object = null;
        try {
            ListIterator<OptimizedCallTarget> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                OptimizedCallTarget optimizedCallTarget = listIterator.next();
                if (!optimizedCallTarget.wasExecuted()) {
                    TruffleLanguage truffleLanguage2 = engineData.getLanguage(optimizedCallTarget);
                    if (truffleLanguage2 != truffleLanguage) {
                        if (truffleLanguage != null) {
                            engineData.leaveLanguage(truffleLanguage, object);
                        }
                        if (truffleLanguage2 != null) {
                            object = engineData.enterLanguage(truffleLanguage2);
                        }
                        truffleLanguage = truffleLanguage2;
                    }
                    if (optimizedCallTarget.prepareForAOT()) continue;
                    listIterator.remove();
                    continue;
                }
                if (!bl) continue;
                listIterator.remove();
            }
        }
        finally {
            if (truffleLanguage != null) {
                engineData.leaveLanguage(truffleLanguage, object);
            }
        }
    }

    private void a(EngineData engineData, Collection<OptimizedCallTarget> collection) {
        int n2 = 0;
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (!optimizedCallTarget.cancelCompilation((CharSequence)"Engine cache compile mode none cancels all compiles if they are not yet completed.")) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.a(engineData, "Cancelled %s compilations.", n2);
            AbstractEngineCacheSupport.b(collection);
        }
    }

    private void b(EngineData engineData, Collection<OptimizedCallTarget> collection) {
        int n2 = 0;
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (optimizedCallTarget.isSubmittedForCompilation()) {
                throw new IllegalStateException("A call target that will be persisted is currently compiling.");
            }
            if (!optimizedCallTarget.invalidate((CharSequence)"CacheCompile mode is none")) continue;
            ++n2;
        }
        if (n2 > 0) {
            AbstractEngineCacheSupport.b(collection);
            this.a(engineData, "%s compilations invalidated.", n2);
        }
    }

    private static void b(Collection<OptimizedCallTarget> collection) {
        OptimizedTruffleRuntime optimizedTruffleRuntime = OptimizedTruffleRuntime.getRuntime();
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            try {
                optimizedTruffleRuntime.waitForCompilation(optimizedCallTarget, Long.MAX_VALUE);
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException | TimeoutException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static void c(Collection<OptimizedCallTarget> collection) {
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            optimizedCallTarget.resetNeedsSplit();
        }
    }

    private static List<OptimizedCallTarget> d(Collection<OptimizedCallTarget> collection) {
        OptimizedCallTarget[] optimizedCallTargetArray = collection.toArray(new OptimizedCallTarget[0]);
        Arrays.sort(optimizedCallTargetArray, new Comparator<OptimizedCallTarget>(){

            public int a(OptimizedCallTarget optimizedCallTarget, OptimizedCallTarget optimizedCallTarget2) {
                int n2 = optimizedCallTarget.getCallAndLoopCount();
                int n3 = optimizedCallTarget2.getCallAndLoopCount();
                return Integer.compare(n3, n2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((OptimizedCallTarget)object, (OptimizedCallTarget)object2);
            }
        });
        return new LinkedList<OptimizedCallTarget>(Arrays.asList(optimizedCallTargetArray));
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a ay = new a();
        public static final /* enum */ a az = new a();
        public static final /* enum */ a aA = new a();
        public static final /* enum */ a aB = new a();
        public static final /* enum */ a aC = new a();
        private static final /* synthetic */ a[] $VALUES;

        public static a[] values() {
            return (a[])$VALUES.clone();
        }

        public static a a(String string) {
            return Enum.valueOf(a.class, string);
        }

        private static /* synthetic */ a[] F() {
            return new a[]{ay, az, aA, aB, aC};
        }

        static {
            $VALUES = a.F();
        }
    }
}

