/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.GuestHostLanguage;
import com.oracle.truffle.polyglot.enterprise.HSContext;
import com.oracle.truffle.polyglot.enterprise.HSObjectReferences;
import com.oracle.truffle.polyglot.enterprise.HSTruffleException;
import com.oracle.truffle.polyglot.enterprise.HSTruffleObject;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativeObjectReferences;
import com.oracle.truffle.polyglot.enterprise.NativeTruffleException;
import com.oracle.truffle.polyglot.enterprise.NativeTruffleObject;
import com.oracle.truffle.polyglot.enterprise.ReferenceUnavailableException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.polyglot.io.ByteSequence;

final class BinaryProtocol {
    private static final byte NULL = 0;
    private static final byte BOOLEAN = 1;
    private static final byte BYTE = 2;
    private static final byte SHORT = 3;
    private static final byte CHAR = 4;
    private static final byte INT = 5;
    private static final byte LONG = 6;
    private static final byte FLOAT = 7;
    private static final byte DOUBLE = 8;
    private static final byte STRING = 9;
    private static final byte TRISTATE = 10;
    private static final byte EXCEPTION_TYPE = 11;
    private static final byte BYTE_ORDER = 12;
    private static final byte ARRAY = 13;
    private static final byte TRUFFLE_LANGUAGE = 14;
    private static final byte GUEST_OBJECT = 15;
    private static final byte HOST_OBJECT = 16;
    private static final byte INTEROP_LIBRARY = 17;
    private static final byte EXCEPTION = 18;
    private static final byte SOURCE_SECTION = 19;
    private static final byte INSTANT = 20;
    private static final byte TRUFFLE_STRING = 21;
    private static final byte LOCAL_DATE = 22;
    private static final byte LOCAL_TIME = 23;
    private static final byte ZONE_ID = 24;
    private static final byte BIG_INTEGER = 25;
    private static final byte EXCEPTION_KIND_INVALID_REFERENCE = 1;
    private static final byte EXCEPTION_KIND_CANCEL_EXECUTION = 2;
    private static final byte EXCEPTION_KIND_INTERRUPT_EXECUTION = 3;
    private static final byte EXCEPTION_KIND_TRUFFLE_EXCEPTION = 4;
    private static final byte EXCEPTION_KIND_INTEROP_UNSUPPORTED_MESSAGE = 5;
    private static final byte EXCEPTION_KIND_INTEROP_UNKNOWN_IDENTIFIER = 6;
    private static final byte EXCEPTION_KIND_INTEROP_UNKNOWN_KEY = 7;
    private static final byte EXCEPTION_KIND_INTEROP_STOP_ITERATION = 8;
    private static final byte EXCEPTION_KIND_INTEROP_ARITY = 9;
    private static final byte EXCEPTION_KIND_INTEROP_UNSUPPORTED_TYPE = 10;
    private static final byte EXCEPTION_KIND_INTEROP_INVALID_ARRAY_INDEX = 11;
    private static final byte EXCEPTION_KIND_INTEROP_INVALID_BUFFER_OFFSET = 12;
    private static final byte EXCEPTION_KIND_EXIT_EXCEPTION = 13;

    private BinaryProtocol() {
    }

    static Object readGuestTypedValue(BinaryInput binaryInput, HSContext hSContext) {
        byte by = binaryInput.readByte();
        switch (by) {
            case 13: {
                int n2 = binaryInput.readInt();
                Object[] objectArray = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = BinaryProtocol.readGuestTypedValue(binaryInput, hSContext);
                }
                return objectArray;
            }
            case 15: {
                return hSContext.hostToGuestReceiver.getObject(binaryInput.readLong());
            }
            case 16: {
                return HSTruffleObject.createHostObjectReference(binaryInput.readLong(), hSContext);
            }
            case 18: {
                return BinaryProtocol.readGuestException(binaryInput, hSContext);
            }
            case 14: {
                return GuestHostLanguage.class;
            }
        }
        return BinaryProtocol.readSimpleTypedValue(binaryInput, by);
    }

    static Object readHostTypedValue(BinaryInput binaryInput, NativeContext nativeContext) {
        byte by = binaryInput.readByte();
        switch (by) {
            case 13: {
                int n2 = binaryInput.readInt();
                Object[] objectArray = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = BinaryProtocol.readHostTypedValue(binaryInput, nativeContext);
                }
                return objectArray;
            }
            case 15: {
                return NativeTruffleObject.createReference(binaryInput.readLong(), nativeContext);
            }
            case 16: {
                return nativeContext.getGuestToHostReceiver().getHostObject(binaryInput.readLong());
            }
            case 18: {
                return BinaryProtocol.readHostException(binaryInput, nativeContext);
            }
        }
        return BinaryProtocol.readSimpleTypedValue(binaryInput, by);
    }

    private static Object readSimpleTypedValue(BinaryInput binaryInput) {
        return BinaryProtocol.readSimpleTypedValue(binaryInput, binaryInput.readByte());
    }

    private static Object readSimpleTypedValue(BinaryInput binaryInput, byte by) {
        switch (by) {
            case 0: {
                return null;
            }
            case 1: {
                return binaryInput.readBoolean();
            }
            case 2: {
                return binaryInput.readByte();
            }
            case 3: {
                return binaryInput.readShort();
            }
            case 4: {
                return Character.valueOf(binaryInput.readChar());
            }
            case 5: {
                return binaryInput.readInt();
            }
            case 6: {
                return binaryInput.readLong();
            }
            case 7: {
                return Float.valueOf(binaryInput.readFloat());
            }
            case 8: {
                return binaryInput.readDouble();
            }
            case 9: {
                return binaryInput.readUTF();
            }
            case 21: {
                return TruffleString.fromJavaStringUncached((String)binaryInput.readUTF(), (TruffleString.Encoding)TruffleString.Encoding.UTF_16);
            }
            case 10: {
                return TriState.values()[binaryInput.readInt()];
            }
            case 12: {
                return binaryInput.readBoolean() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            }
            case 11: {
                return ExceptionType.values()[binaryInput.readInt()];
            }
            case 17: {
                return InteropLibrary.getUncached();
            }
            case 19: {
                return BinaryProtocol.readSourceSection(binaryInput);
            }
            case 20: {
                return Instant.ofEpochSecond(binaryInput.readLong(), binaryInput.readInt());
            }
            case 22: {
                return LocalDate.ofEpochDay(binaryInput.readLong());
            }
            case 23: {
                return LocalTime.ofNanoOfDay(binaryInput.readLong());
            }
            case 24: {
                return ZoneId.of(binaryInput.readUTF());
            }
            case 25: {
                int n2 = binaryInput.readInt();
                byte[] byArray = new byte[n2];
                binaryInput.read(byArray, 0, byArray.length);
                return new BigInteger(byArray);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown tag %d", by));
    }

    private static SourceSection readSourceSection(BinaryInput binaryInput) {
        Source source = BinaryProtocol.readSource(binaryInput);
        boolean bl = binaryInput.readBoolean();
        if (bl) {
            if (binaryInput.readBoolean()) {
                int n2 = binaryInput.readInt();
                int n3 = binaryInput.readInt();
                return source.createSection(n2, n3);
            }
            if (binaryInput.readBoolean()) {
                int n4 = binaryInput.readInt();
                int n5 = binaryInput.readInt();
                if (binaryInput.readBoolean()) {
                    int n6 = binaryInput.readInt();
                    int n7 = binaryInput.readInt();
                    return source.createSection(n4, n6, n5, n7);
                }
                return source.createSection(n4, n5);
            }
        }
        return source.createUnavailableSection();
    }

    private static Source readSource(BinaryInput binaryInput) {
        Source.LiteralBuilder literalBuilder;
        String string = binaryInput.readUTF();
        String string2 = binaryInput.readUTF();
        String string3 = (String)BinaryProtocol.readSimpleTypedValue(binaryInput);
        String string4 = (String)BinaryProtocol.readSimpleTypedValue(binaryInput);
        boolean bl = binaryInput.readBoolean();
        boolean bl2 = binaryInput.readBoolean();
        boolean bl3 = binaryInput.readBoolean();
        boolean bl4 = binaryInput.readBoolean();
        boolean bl5 = binaryInput.readBoolean();
        if (bl4) {
            literalBuilder = Source.newBuilder((String)string2, (CharSequence)binaryInput.readUTF(), (String)string);
        } else if (bl5) {
            int n2 = binaryInput.readInt();
            byte[] byArray = new byte[n2];
            binaryInput.read(byArray, 0, n2);
            literalBuilder = Source.newBuilder((String)string2, (ByteSequence)ByteSequence.create((byte[])byArray), (String)string);
        } else {
            literalBuilder = Source.newBuilder((String)string2, (CharSequence)"", (String)string).content(Source.CONTENT_NONE);
        }
        literalBuilder.interactive(bl);
        literalBuilder.internal(bl2);
        literalBuilder.cached(bl3);
        if (string3 != null) {
            literalBuilder.uri(URI.create(string3));
        }
        if (string4 != null) {
            literalBuilder.mimeType(string4);
        }
        try {
            return literalBuilder.build();
        }
        catch (IOException iOException) {
            throw CompilerDirectives.shouldNotReachHere((String)"Unexpected IOException", (Throwable)iOException);
        }
    }

    private static Throwable readGuestException(BinaryInput binaryInput, HSContext hSContext) {
        byte by = binaryInput.readByte();
        switch (by) {
            case 7: {
                Object object = BinaryProtocol.readGuestTypedValue(binaryInput, hSContext);
                return UnknownKeyException.create((Object)object);
            }
            case 10: {
                Object[] objectArray = (Object[])BinaryProtocol.readGuestTypedValue(binaryInput, hSContext);
                return UnsupportedTypeException.create((Object[])objectArray);
            }
            case 4: {
                byte by2 = binaryInput.readByte();
                long l2 = binaryInput.readLong();
                if (by2 == 15) {
                    return (Throwable)hSContext.hostToGuestReceiver.getObject(l2);
                }
                if (by2 == 16) {
                    HSTruffleObject hSTruffleObject = HSTruffleObject.createHostObjectReference(l2, hSContext);
                    return new HSTruffleException(hSTruffleObject);
                }
                throw new IllegalArgumentException(String.format("Unexpected object type %d", by2));
            }
        }
        return BinaryProtocol.readCommonException(binaryInput, by);
    }

    private static Throwable readHostException(BinaryInput binaryInput, NativeContext nativeContext) {
        byte by = binaryInput.readByte();
        switch (by) {
            case 7: {
                Object object = BinaryProtocol.readHostTypedValue(binaryInput, nativeContext);
                return UnknownKeyException.create((Object)object);
            }
            case 10: {
                Object[] objectArray = (Object[])BinaryProtocol.readHostTypedValue(binaryInput, nativeContext);
                return UnsupportedTypeException.create((Object[])objectArray);
            }
            case 4: {
                byte by2 = binaryInput.readByte();
                long l2 = binaryInput.readLong();
                if (by2 == 15) {
                    NativeTruffleObject nativeTruffleObject = NativeTruffleObject.createReference(l2, nativeContext);
                    return new NativeTruffleException(nativeTruffleObject);
                }
                if (by2 == 16) {
                    return (Throwable)nativeContext.getGuestToHostReceiver().getHostObject(l2);
                }
                throw new IllegalArgumentException(String.format("Unexpected object type %d", by2));
            }
        }
        return BinaryProtocol.readCommonException(binaryInput, by);
    }

    private static Throwable readCommonException(BinaryInput binaryInput, byte by) {
        switch (by) {
            case 5: {
                return UnsupportedMessageException.create();
            }
            case 6: {
                return UnknownIdentifierException.create((String)binaryInput.readUTF());
            }
            case 11: {
                long l2 = binaryInput.readLong();
                return InvalidArrayIndexException.create((long)l2);
            }
            case 8: {
                return StopIterationException.create();
            }
            case 12: {
                long l3 = binaryInput.readLong();
                long l4 = binaryInput.readLong();
                return InvalidBufferOffsetException.create((long)l3, (long)l4);
            }
            case 9: {
                int n2 = binaryInput.readInt();
                int n3 = binaryInput.readInt();
                int n4 = binaryInput.readInt();
                return ArityException.create((int)n2, (int)n3, (int)n4);
            }
            case 2: {
                boolean bl = binaryInput.readBoolean();
                String string = binaryInput.readUTF();
                SourceSection sourceSection = (SourceSection)BinaryProtocol.readSimpleTypedValue(binaryInput);
                return EnterpriseEngineAccessor.ENGINE.createCancelExecution(sourceSection, string, bl);
            }
            case 13: {
                int n5 = binaryInput.readInt();
                String string = binaryInput.readUTF();
                SourceSection sourceSection = (SourceSection)BinaryProtocol.readSimpleTypedValue(binaryInput);
                return EnterpriseEngineAccessor.ENGINE.createExitException(sourceSection, string, n5);
            }
            case 3: {
                SourceSection sourceSection = (SourceSection)BinaryProtocol.readSimpleTypedValue(binaryInput);
                return EnterpriseEngineAccessor.ENGINE.createInterruptExecution(sourceSection);
            }
            case 1: {
                String string = binaryInput.readUTF();
                return new ReferenceUnavailableException(string);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported exception type %d", by));
    }

    static void writeGuestTypedValue(BinaryOutput binaryOutput, Object object, HSObjectReferences hSObjectReferences) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            binaryOutput.writeByte(13);
            binaryOutput.writeInt(objectArray.length);
            for (Object object2 : objectArray) {
                BinaryProtocol.writeGuestTypedValue(binaryOutput, object2, hSObjectReferences);
            }
        } else if (object instanceof HSTruffleObject) {
            binaryOutput.writeByte(16);
            binaryOutput.writeLong(((HSTruffleObject)object).getHostReferenceId());
        } else if (object instanceof Throwable) {
            BinaryProtocol.writeGuestException(binaryOutput, (Throwable)object, hSObjectReferences);
        } else if (object instanceof TruffleObject) {
            binaryOutput.writeByte(15);
            long l2 = hSObjectReferences.registerGuestObject((TruffleObject)object);
            binaryOutput.writeLong(l2);
        } else {
            BinaryProtocol.writeSimpleTypedValue(binaryOutput, object);
        }
    }

    static void writeHostTypedValue(BinaryOutput binaryOutput, Object object, NativeObjectReferences nativeObjectReferences) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            binaryOutput.writeByte(13);
            binaryOutput.writeInt(objectArray.length);
            for (Object object2 : objectArray) {
                BinaryProtocol.writeHostTypedValue(binaryOutput, object2, nativeObjectReferences);
            }
        } else if (object instanceof NativeTruffleObject) {
            binaryOutput.writeByte(15);
            binaryOutput.writeLong(((NativeTruffleObject)object).getGuestReferenceId());
        } else if (object instanceof Throwable) {
            BinaryProtocol.writeHostException(binaryOutput, (Throwable)object, nativeObjectReferences);
        } else if (object instanceof TruffleObject) {
            binaryOutput.writeByte(16);
            binaryOutput.writeLong(nativeObjectReferences.registerHostObject((TruffleObject)object));
        } else if (object instanceof Class && TruffleLanguage.class.isAssignableFrom((Class)object)) {
            binaryOutput.writeByte(14);
        } else {
            BinaryProtocol.writeSimpleTypedValue(binaryOutput, object);
        }
    }

    static boolean isSupportedException(Throwable throwable) {
        return throwable instanceof InteropException || throwable instanceof AbstractTruffleException || throwable instanceof ReferenceUnavailableException || EnterpriseEngineAccessor.ENGINE.isCancelExecution(throwable) || EnterpriseEngineAccessor.ENGINE.isExitException(throwable);
    }

    private static void writeSimpleTypedValue(BinaryOutput binaryOutput, Object object) {
        if (object == null) {
            binaryOutput.writeByte(0);
        } else if (object instanceof Boolean) {
            binaryOutput.writeByte(1);
            binaryOutput.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof Byte) {
            binaryOutput.writeByte(2);
            binaryOutput.writeByte((int)((Byte)object).byteValue());
        } else if (object instanceof Short) {
            binaryOutput.writeByte(3);
            binaryOutput.writeShort((int)((Short)object).shortValue());
        } else if (object instanceof Character) {
            binaryOutput.writeByte(4);
            binaryOutput.writeChar((int)((Character)object).charValue());
        } else if (object instanceof Integer) {
            binaryOutput.writeByte(5);
            binaryOutput.writeInt(((Integer)object).intValue());
        } else if (object instanceof Long) {
            binaryOutput.writeByte(6);
            binaryOutput.writeLong(((Long)object).longValue());
        } else if (object instanceof Float) {
            binaryOutput.writeByte(7);
            binaryOutput.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            binaryOutput.writeByte(8);
            binaryOutput.writeDouble(((Double)object).doubleValue());
        } else if (object instanceof String) {
            binaryOutput.writeByte(9);
            binaryOutput.writeUTF((String)object);
        } else if (object instanceof TruffleString) {
            binaryOutput.writeByte(21);
            binaryOutput.writeUTF(((TruffleString)object).toJavaStringUncached());
        } else if (object instanceof TriState) {
            binaryOutput.writeByte(10);
            binaryOutput.writeInt(((TriState)object).ordinal());
        } else if (object instanceof ByteOrder) {
            binaryOutput.writeByte(12);
            binaryOutput.writeBoolean(object == ByteOrder.BIG_ENDIAN);
        } else if (object instanceof ExceptionType) {
            binaryOutput.writeByte(11);
            binaryOutput.writeInt(((ExceptionType)object).ordinal());
        } else if (object instanceof InteropLibrary) {
            binaryOutput.writeByte(17);
        } else if (object instanceof SourceSection) {
            BinaryProtocol.writeSourceSection(binaryOutput, (SourceSection)object);
        } else if (object instanceof Instant) {
            binaryOutput.writeByte(20);
            binaryOutput.writeLong(((Instant)object).getEpochSecond());
            binaryOutput.writeInt(((Instant)object).getNano());
        } else if (object instanceof LocalDate) {
            binaryOutput.writeByte(22);
            binaryOutput.writeLong(((LocalDate)object).toEpochDay());
        } else if (object instanceof LocalTime) {
            binaryOutput.writeByte(23);
            binaryOutput.writeLong(((LocalTime)object).toNanoOfDay());
        } else if (object instanceof ZoneId) {
            binaryOutput.writeByte(24);
            binaryOutput.writeUTF(((ZoneId)object).getId());
        } else if (object instanceof BigInteger) {
            binaryOutput.writeByte(25);
            byte[] byArray = ((BigInteger)object).toByteArray();
            binaryOutput.writeInt(byArray.length);
            binaryOutput.write(byArray, 0, byArray.length);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type %s", object.getClass()));
        }
    }

    private static void writeSourceSection(BinaryOutput binaryOutput, SourceSection sourceSection) {
        binaryOutput.writeByte(19);
        BinaryProtocol.writeSource(binaryOutput, sourceSection.getSource());
        boolean bl = sourceSection.isAvailable();
        binaryOutput.writeBoolean(bl);
        if (bl) {
            boolean bl2 = sourceSection.hasCharIndex();
            binaryOutput.writeBoolean(bl2);
            if (bl2) {
                binaryOutput.writeInt(sourceSection.getCharIndex());
                binaryOutput.writeInt(sourceSection.getCharLength());
            } else {
                boolean bl3 = sourceSection.hasLines();
                binaryOutput.writeBoolean(bl3);
                if (bl3) {
                    binaryOutput.writeInt(sourceSection.getStartLine());
                    binaryOutput.writeInt(sourceSection.getEndLine());
                    boolean bl4 = sourceSection.hasColumns();
                    binaryOutput.writeBoolean(bl4);
                    if (bl3) {
                        binaryOutput.writeInt(sourceSection.getStartColumn());
                        binaryOutput.writeInt(sourceSection.getEndColumn());
                    }
                }
            }
        }
    }

    private static void writeSource(BinaryOutput binaryOutput, Source source) {
        binaryOutput.writeUTF(source.getName());
        binaryOutput.writeUTF(source.getLanguage());
        URI uRI = source.getURI();
        BinaryProtocol.writeSimpleTypedValue(binaryOutput, uRI == null ? null : uRI.toString());
        BinaryProtocol.writeSimpleTypedValue(binaryOutput, source.getMimeType());
        binaryOutput.writeBoolean(source.isInteractive());
        binaryOutput.writeBoolean(source.isInternal());
        binaryOutput.writeBoolean(source.isCached());
        boolean bl = source.hasCharacters();
        boolean bl2 = source.hasBytes();
        binaryOutput.writeBoolean(bl);
        binaryOutput.writeBoolean(bl2);
        if (bl) {
            binaryOutput.writeUTF(source.getCharacters().toString());
        } else if (bl2) {
            ByteSequence byteSequence = source.getBytes();
            binaryOutput.writeInt(byteSequence.length());
            binaryOutput.write(byteSequence.toByteArray(), 0, byteSequence.length());
        }
    }

    private static void writeHostException(BinaryOutput binaryOutput, Throwable throwable, NativeObjectReferences nativeObjectReferences) {
        binaryOutput.writeByte(18);
        if (throwable instanceof InteropException) {
            if (throwable instanceof UnknownKeyException) {
                binaryOutput.writeByte(7);
                BinaryProtocol.writeHostTypedValue(binaryOutput, ((UnknownKeyException)throwable).getUnknownKey(), nativeObjectReferences);
            } else if (throwable instanceof UnsupportedTypeException) {
                binaryOutput.writeByte(10);
                BinaryProtocol.writeHostTypedValue(binaryOutput, ((UnsupportedTypeException)throwable).getSuppliedValues(), nativeObjectReferences);
            } else {
                BinaryProtocol.writeCommonInteropException(binaryOutput, (InteropException)throwable);
            }
        } else if (throwable instanceof TruffleObject) {
            binaryOutput.writeByte(4);
            if (throwable instanceof NativeTruffleException) {
                binaryOutput.writeByte(15);
                binaryOutput.writeLong(((NativeTruffleException)((Object)throwable)).reference.getGuestReferenceId());
            } else {
                binaryOutput.writeByte(16);
                binaryOutput.writeLong(nativeObjectReferences.registerHostObject((TruffleObject)throwable));
            }
        } else {
            BinaryProtocol.writeCommonException(binaryOutput, throwable);
        }
    }

    private static void writeGuestException(BinaryOutput binaryOutput, Throwable throwable, HSObjectReferences hSObjectReferences) {
        binaryOutput.writeByte(18);
        if (throwable instanceof InteropException) {
            if (throwable instanceof UnknownKeyException) {
                binaryOutput.writeByte(7);
                BinaryProtocol.writeGuestTypedValue(binaryOutput, ((UnknownKeyException)throwable).getUnknownKey(), hSObjectReferences);
            } else if (throwable instanceof UnsupportedTypeException) {
                binaryOutput.writeByte(10);
                BinaryProtocol.writeGuestTypedValue(binaryOutput, ((UnsupportedTypeException)throwable).getSuppliedValues(), hSObjectReferences);
            } else {
                BinaryProtocol.writeCommonInteropException(binaryOutput, (InteropException)throwable);
            }
        } else if (throwable instanceof TruffleObject) {
            binaryOutput.writeByte(4);
            if (throwable instanceof HSTruffleException) {
                binaryOutput.writeByte(16);
                binaryOutput.writeLong(((HSTruffleException)((Object)throwable)).reference.getHostReferenceId());
            } else {
                binaryOutput.writeByte(15);
                binaryOutput.writeLong(hSObjectReferences.registerGuestObject((TruffleObject)throwable));
            }
        } else {
            BinaryProtocol.writeCommonException(binaryOutput, throwable);
        }
    }

    private static void writeCommonException(BinaryOutput binaryOutput, Throwable throwable) {
        if (throwable instanceof ReferenceUnavailableException) {
            binaryOutput.writeByte(1);
            binaryOutput.writeUTF(throwable.getMessage());
        } else if (EnterpriseEngineAccessor.ENGINE.isCancelExecution(throwable)) {
            binaryOutput.writeByte(2);
            binaryOutput.writeBoolean(EnterpriseEngineAccessor.ENGINE.isResourceLimitCancelExecution(throwable));
            binaryOutput.writeUTF(throwable.getMessage());
            BinaryProtocol.writeSimpleTypedValue(binaryOutput, EnterpriseEngineAccessor.ENGINE.getCancelExecutionSourceLocation(throwable));
        } else if (EnterpriseEngineAccessor.ENGINE.isExitException(throwable)) {
            binaryOutput.writeByte(13);
            binaryOutput.writeInt(EnterpriseEngineAccessor.ENGINE.getExitExceptionExitCode(throwable));
            binaryOutput.writeUTF(throwable.getMessage());
            BinaryProtocol.writeSimpleTypedValue(binaryOutput, EnterpriseEngineAccessor.ENGINE.getExitExceptionSourceLocation(throwable));
        } else if (EnterpriseEngineAccessor.ENGINE.isInterruptExecution(throwable)) {
            binaryOutput.writeByte(3);
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            SourceSection sourceSection = null;
            if (interopLibrary.hasSourceLocation((Object)throwable)) {
                try {
                    sourceSection = interopLibrary.getSourceLocation((Object)throwable);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)unsupportedMessageException);
                }
            }
            BinaryProtocol.writeSimpleTypedValue(binaryOutput, sourceSection);
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Unsupported exception %s", throwable));
            illegalArgumentException.addSuppressed(throwable);
            throw illegalArgumentException;
        }
    }

    private static void writeCommonInteropException(BinaryOutput binaryOutput, InteropException interopException) {
        if (interopException instanceof UnsupportedMessageException) {
            binaryOutput.writeByte(5);
        } else if (interopException instanceof UnknownIdentifierException) {
            binaryOutput.writeByte(6);
            binaryOutput.writeUTF(((UnknownIdentifierException)interopException).getUnknownIdentifier());
        } else if (interopException instanceof InvalidArrayIndexException) {
            binaryOutput.writeByte(11);
            binaryOutput.writeLong(((InvalidArrayIndexException)interopException).getInvalidIndex());
        } else if (interopException instanceof StopIterationException) {
            binaryOutput.writeByte(8);
        } else if (interopException instanceof InvalidBufferOffsetException) {
            binaryOutput.writeByte(12);
            InvalidBufferOffsetException invalidBufferOffsetException = (InvalidBufferOffsetException)interopException;
            binaryOutput.writeLong(invalidBufferOffsetException.getByteOffset());
            binaryOutput.writeLong(invalidBufferOffsetException.getLength());
        } else if (interopException instanceof ArityException) {
            binaryOutput.writeByte(9);
            ArityException arityException = (ArityException)interopException;
            binaryOutput.writeInt(arityException.getExpectedMinArity());
            binaryOutput.writeInt(arityException.getExpectedMaxArity());
            binaryOutput.writeInt(arityException.getActualArity());
        } else {
            throw new IllegalArgumentException(String.format("Unsupported interop exception %s", interopException));
        }
    }
}

