/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.DataViewPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSDataView
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("DataView");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("DataView.prototype");
    public static final JSDataView INSTANCE = new JSDataView();

    private JSDataView() {
    }

    public static JSDataViewObject createDataView(JSContext context, JSRealm realm, JSArrayBufferObject arrayBuffer, int offset, int length) {
        return JSDataView.createDataView(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), arrayBuffer, offset, length);
    }

    public static JSDataViewObject createDataView(JSContext context, JSRealm realm, JSDynamicObject proto, JSArrayBufferObject arrayBuffer, int offset, int length) {
        JSObjectFactory factory = context.getDataViewFactory();
        Shape shape = factory.getShape(realm, proto);
        JSDataViewObject newObj = factory.initProto(new JSDataViewObject(shape, proto, arrayBuffer, length, offset), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, DataViewPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, DataViewPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    public static int dataViewGetByteLength(JSDataViewObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(thisObj.getArrayBuffer())) {
            return 0;
        }
        return thisObj.getLength();
    }

    public static int dataViewGetByteOffset(JSDataViewObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(thisObj.getArrayBuffer())) {
            return 0;
        }
        return thisObj.getOffset();
    }

    public static boolean isOutOfBounds(JSDataViewObject dataView, JSContext ctx) {
        if (!ctx.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(dataView.getArrayBuffer())) {
            return true;
        }
        if (ctx.getArrayBufferNotShrunkAssumption().isValid()) {
            return false;
        }
        long bufferByteLength = dataView.getArrayBuffer().getByteLength();
        int byteOffsetStart = dataView.getOffset();
        long byteOffsetEnd = dataView.hasAutoLength() ? bufferByteLength : (long)(byteOffsetStart + dataView.getLength());
        return (long)byteOffsetStart > bufferByteLength || byteOffsetEnd > bufferByteLength;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape childTree = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return childTree;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSDataView(Object obj) {
        return obj instanceof JSDataViewObject;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDataViewPrototype();
    }
}

