/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayDeque;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorHandlerTask;
import org.glassfish.grizzly.nio.Selectors;
import org.glassfish.grizzly.threadpool.Threads;
import org.glassfish.grizzly.utils.StateHolder;

public final class SelectorRunner
implements Runnable {
    private static final Logger LOGGER = Grizzly.logger(SelectorRunner.class);
    private static final String THREAD_MARKER = " SelectorRunner";
    private final NIOTransport transport;
    private final AtomicReference<Transport.State> stateHolder;
    private final Queue<SelectorHandlerTask> pendingTasks;
    private Queue<SelectorHandlerTask> currentPostponedTasks;
    private final Queue<SelectorHandlerTask> evenPostponedTasks;
    private final Queue<SelectorHandlerTask> oddPostponedTasks;
    private volatile int dumbVolatile = 1;
    private Selector selector;
    private Thread selectorRunnerThread;
    private boolean isResume;
    private int lastSelectedKeysCount;
    private Set<SelectionKey> readyKeySet;
    private Iterator<SelectionKey> iterator;
    private SelectionKey key = null;
    private int keyReadyOps;
    private final AtomicBoolean selectorWakeupFlag = new AtomicBoolean();
    private final AtomicInteger runnerThreadActivityCounter = new AtomicInteger();
    volatile boolean hasPendingTasks;
    private long lastSpinTimestamp;
    private int emptySpinCounter;
    private final Map<Selector, Long> spinnedSelectorsHistory = new WeakHashMap<Selector, Long>();

    public static SelectorRunner create(NIOTransport transport) throws IOException {
        return new SelectorRunner(transport, Selectors.newSelector(transport.getSelectorProvider()));
    }

    private SelectorRunner(NIOTransport transport, Selector selector) {
        this.transport = transport;
        this.selector = selector;
        this.stateHolder = new AtomicReference<Transport.State>(Transport.State.STOPPED);
        this.pendingTasks = new ConcurrentLinkedQueue<SelectorHandlerTask>();
        this.evenPostponedTasks = new ArrayDeque<SelectorHandlerTask>();
        this.oddPostponedTasks = new ArrayDeque<SelectorHandlerTask>();
        this.currentPostponedTasks = this.evenPostponedTasks;
    }

    void addPendingTask(SelectorHandlerTask task) {
        this.pendingTasks.offer(task);
        this.hasPendingTasks = true;
        this.wakeupSelector();
    }

    private void wakeupSelector() {
        Selector localSelector = this.getSelector();
        if (localSelector != null && this.selectorWakeupFlag.compareAndSet(false, true)) {
            try {
                localSelector.wakeup();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error during selector wakeup", e);
            }
        }
    }

    public NIOTransport getTransport() {
        return this.transport;
    }

    public Selector getSelector() {
        if (this.dumbVolatile != 0) {
            return this.selector;
        }
        return null;
    }

    void setSelector(Selector selector) {
        this.selector = selector;
        ++this.dumbVolatile;
    }

    private void setRunnerThread(Thread runnerThread) {
        this.selectorRunnerThread = runnerThread;
        ++this.dumbVolatile;
    }

    public Thread getRunnerThread() {
        if (this.dumbVolatile != 0) {
            return this.selectorRunnerThread;
        }
        return null;
    }

    public Transport.State getState() {
        return this.stateHolder.get();
    }

    public void postpone() {
        assert (this.selectorRunnerThread != null);
        this.removeThreadNameMarker(this.selectorRunnerThread);
        Threads.setService(false);
        this.runnerThreadActivityCounter.compareAndSet(1, 0);
        this.selectorRunnerThread = null;
        this.isResume = true;
        ++this.dumbVolatile;
    }

    public synchronized void start() {
        if (!this.stateHolder.compareAndSet(Transport.State.STOPPED, Transport.State.STARTING)) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_SELECTOR_RUNNER_NOT_IN_STOPPED_STATE_EXCEPTION());
            return;
        }
        this.transport.getKernelThreadPool().execute(this);
    }

    public synchronized void stop() {
        this.stateHolder.set(Transport.State.STOPPING);
        this.wakeupSelector();
        if (this.runnerThreadActivityCounter.compareAndSet(0, -1)) {
            this.shutdownSelector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownSelector() {
        Selector localSelector = this.getSelector();
        if (localSelector != null) {
            try {
                SelectionKey[] keys = new SelectionKey[]{};
                while (true) {
                    try {
                        keys = localSelector.keys().toArray(keys);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
                for (SelectionKey selectionKey : keys) {
                    NIOConnection connection = this.transport.getSelectionKeyHandler().getConnectionForKey(selectionKey);
                    connection.terminateSilently();
                }
            }
            catch (ClosedSelectorException closedSelectorException) {
            }
            finally {
                try {
                    localSelector.close();
                }
                catch (Exception exception) {}
            }
        }
        this.abortTasksInQueue(this.pendingTasks);
        this.abortTasksInQueue(this.evenPostponedTasks);
        this.abortTasksInQueue(this.oddPostponedTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.runnerThreadActivityCounter.compareAndSet(0, 1)) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        try {
            if (!this.isResume) {
                if (!this.stateHolder.compareAndSet(Transport.State.STARTING, Transport.State.STARTED)) {
                    return;
                }
                this.addThreadNameMarker(currentThread);
            }
            this.setRunnerThread(currentThread);
            Threads.setService(true);
            StateHolder<Transport.State> transportStateHolder = this.transport.getState();
            boolean isSkipping = false;
            while (!isSkipping && !this.isStop()) {
                if (transportStateHolder.getState() != Transport.State.PAUSED) {
                    isSkipping = !this.doSelect();
                    continue;
                }
                try {
                    transportStateHolder.notifyWhenStateIsNotEqual(Transport.State.PAUSED, null).get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.runnerThreadActivityCounter.compareAndSet(1, 0);
            if (this.isStop()) {
                this.stateHolder.set(Transport.State.STOPPED);
                this.setRunnerThread(null);
                if (this.runnerThreadActivityCounter.compareAndSet(0, -1)) {
                    this.shutdownSelector();
                }
            }
            this.removeThreadNameMarker(currentThread);
            Threads.setService(false);
        }
    }

    protected boolean doSelect() {
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        try {
            if (this.isResume) {
                this.isResume = false;
                if (this.readyKeySet != null) {
                    if (this.keyReadyOps != 0 && !this.iterateKeyEvents()) {
                        return false;
                    }
                    if (!this.iterateKeys()) {
                        return false;
                    }
                    this.readyKeySet.clear();
                }
            }
            this.lastSelectedKeysCount = 0;
            if (!selectorHandler.preSelect(this)) {
                return false;
            }
            this.readyKeySet = selectorHandler.select(this);
            this.selectorWakeupFlag.set(false);
            if (this.stateHolder.get() == Transport.State.STOPPING) {
                return true;
            }
            this.lastSelectedKeysCount = this.readyKeySet.size();
            if (this.lastSelectedKeysCount != 0) {
                this.iterator = this.readyKeySet.iterator();
                if (!this.iterateKeys()) {
                    return false;
                }
                this.readyKeySet.clear();
            }
            this.readyKeySet = null;
            this.iterator = null;
            selectorHandler.postSelect(this);
        }
        catch (ClosedSelectorException e) {
            if (this.isRunning() && selectorHandler.onSelectorClosed(this)) {
                return true;
            }
            this.dropConnectionDueToException(this.key, "Selector was unexpectedly closed", e, Level.SEVERE, Level.FINE);
        }
        catch (Exception e) {
            this.dropConnectionDueToException(this.key, "doSelect exception", e, Level.SEVERE, Level.FINE);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "doSelect exception", t);
            this.transport.notifyTransportError(t);
        }
        return true;
    }

    private boolean iterateKeys() {
        Iterator<SelectionKey> it = this.iterator;
        while (it.hasNext()) {
            try {
                this.key = it.next();
                this.keyReadyOps = this.key.readyOps();
                if (this.iterateKeyEvents()) continue;
                return false;
            }
            catch (IOException e) {
                this.keyReadyOps = 0;
                this.dropConnectionDueToException(this.key, "Unexpected IOException. Channel " + this.key.channel() + " will be closed.", e, Level.WARNING, Level.FINE);
            }
            catch (CancelledKeyException e) {
                this.keyReadyOps = 0;
                this.dropConnectionDueToException(this.key, "Unexpected CancelledKeyException. Channel " + this.key.channel() + " will be closed.", e, Level.FINE, Level.FINE);
            }
        }
        return true;
    }

    private boolean iterateKeyEvents() throws IOException {
        SelectionKey keyLocal = this.key;
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        IOStrategy ioStrategy = this.transport.getIOStrategy();
        IOEvent[] ioEvents = selectionKeyHandler.getIOEvents(this.keyReadyOps);
        NIOConnection connection = selectionKeyHandler.getConnectionForKey(keyLocal);
        for (IOEvent ioEvent : ioEvents) {
            NIOConnection.notifyIOEventReady(connection, ioEvent);
            int interest = ioEvent.getSelectionKeyInterest();
            this.keyReadyOps &= ~interest;
            if (!selectionKeyHandler.onProcessInterest(keyLocal, interest) || ioStrategy.executeIoEvent(connection, ioEvent)) continue;
            return false;
        }
        return true;
    }

    public Queue<SelectorHandlerTask> getPendingTasks() {
        this.hasPendingTasks = false;
        return this.pendingTasks;
    }

    public Queue<SelectorHandlerTask> getPostponedTasks() {
        return this.currentPostponedTasks;
    }

    public Queue<SelectorHandlerTask> obtainPostponedTasks() {
        Queue<SelectorHandlerTask> tasksToReturn = this.currentPostponedTasks;
        this.currentPostponedTasks = this.currentPostponedTasks == this.evenPostponedTasks ? this.oddPostponedTasks : this.evenPostponedTasks;
        return tasksToReturn;
    }

    boolean isStop() {
        Transport.State state = this.stateHolder.get();
        return state == Transport.State.STOPPED || state == Transport.State.STOPPING;
    }

    private boolean isRunning() {
        return this.stateHolder.get() == Transport.State.STARTED;
    }

    private void dropConnectionDueToException(SelectionKey key, String description, Exception e, Level runLogLevel, Level stoppedLogLevel) {
        if (this.isRunning()) {
            LOGGER.log(runLogLevel, description, e);
            if (key != null) {
                try {
                    NIOConnection connection = this.transport.getSelectionKeyHandler().getConnectionForKey(key);
                    if (connection != null) {
                        connection.closeSilently();
                    } else {
                        SelectableChannel channel = key.channel();
                        this.transport.getSelectionKeyHandler().cancel(key);
                        channel.close();
                    }
                }
                catch (IOException cancelException) {
                    LOGGER.log(Level.FINE, "IOException during cancelling key", cancelException);
                }
            }
            this.transport.notifyTransportError(e);
        } else {
            LOGGER.log(stoppedLogLevel, description, e);
        }
    }

    public int getLastSelectedKeysCount() {
        return this.lastSelectedKeysCount;
    }

    protected void switchToNewSelector() throws IOException {
        Selector oldSelector = this.selector;
        Selector newSelector = Selectors.newSelector(this.transport.getSelectorProvider());
        Set<SelectionKey> keys = oldSelector.keys();
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        for (SelectionKey selectionKey : keys) {
            if (!selectionKey.isValid()) continue;
            try {
                NIOConnection nioConnection = selectionKeyHandler.getConnectionForKey(selectionKey);
                SelectionKey newSelectionKey = selectionKey.channel().register(newSelector, selectionKey.interestOps(), selectionKey.attachment());
                nioConnection.onSelectionKeyUpdated(newSelectionKey);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error switching channel to a new selector", e);
            }
        }
        this.setSelector(newSelector);
        try {
            oldSelector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void abortTasksInQueue(Queue<SelectorHandlerTask> taskQueue) {
        SelectorHandlerTask task;
        while ((task = taskQueue.poll()) != null) {
            try {
                task.cancel();
            }
            catch (Exception exception) {}
        }
    }

    void resetSpinCounter() {
        this.emptySpinCounter = 0;
    }

    int incSpinCounter() {
        if (this.emptySpinCounter++ == 0) {
            this.lastSpinTimestamp = System.nanoTime();
        } else if (this.emptySpinCounter == 1000) {
            long deltatime = System.nanoTime() - this.lastSpinTimestamp;
            int contspinspersec = (int)(1000000000000L / deltatime);
            this.emptySpinCounter = 0;
            return contspinspersec;
        }
        return 0;
    }

    SelectionKey checkIfSpinnedKey(SelectionKey key) {
        if (!key.isValid() && key.channel().isOpen() && this.spinnedSelectorsHistory.containsKey(key.selector())) {
            SelectionKey newKey = key.channel().keyFor(this.getSelector());
            newKey.attach(key.attachment());
            return newKey;
        }
        return key;
    }

    void workaroundSelectorSpin() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Workaround selector spin. selector={0}", this.getSelector());
        }
        this.spinnedSelectorsHistory.put(this.getSelector(), System.currentTimeMillis());
        this.switchToNewSelector();
    }

    void checkSelectorSpin(boolean hasSelectedKeys, int spinRateThreshold) throws IOException {
        if (hasSelectedKeys) {
            this.resetSpinCounter();
        } else {
            long sr = this.incSpinCounter();
            if (sr > (long)spinRateThreshold) {
                this.workaroundSelectorSpin();
            }
        }
    }

    private void addThreadNameMarker(Thread currentThread) {
        String name = currentThread.getName();
        if (!name.endsWith(THREAD_MARKER)) {
            currentThread.setName(name + THREAD_MARKER);
        }
    }

    private void removeThreadNameMarker(Thread currentThread) {
        String name = currentThread.getName();
        if (name.endsWith(THREAD_MARKER)) {
            currentThread.setName(name.substring(0, name.length() - THREAD_MARKER.length()));
        }
    }
}

