/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.services.BugzillaService;
import org.gitlab4j.api.services.CustomIssueTrackerService;
import org.gitlab4j.api.services.ExternalWikiService;
import org.gitlab4j.api.services.HipChatService;
import org.gitlab4j.api.services.JiraService;
import org.gitlab4j.api.services.MattermostService;
import org.gitlab4j.api.services.SlackService;

public class ServicesApi
extends AbstractApi {
    public ServicesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public void setGitLabCI(Object projectIdOrPath, String token, String projectCIUrl) throws GitLabApiException {
        Form formData = new Form();
        formData.param("token", token);
        formData.param("project_url", projectCIUrl);
        this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "gitlab-ci");
    }

    public void deleteGitLabCI(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "gitlab-ci");
    }

    public HipChatService getHipChatService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
        return (HipChatService)response.readEntity(HipChatService.class);
    }

    public HipChatService updateHipChatService(Object projectIdOrPath, HipChatService hipChat) throws GitLabApiException {
        GitLabApiForm formData = hipChat.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
        return (HipChatService)response.readEntity(HipChatService.class);
    }

    public void setHipChat(Object projectIdOrPath, String token, String room, String server) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("token", token).withParam("room", room).withParam("server", server);
        this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
    }

    public void deleteHipChat(Object projectIdOrPath) throws GitLabApiException {
        this.deleteHipChatService(projectIdOrPath);
    }

    public void deleteHipChatService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "hipchat");
    }

    public SlackService getSlackService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "slack");
        return (SlackService)response.readEntity(SlackService.class);
    }

    public SlackService updateSlackService(Object projectIdOrPath, SlackService slackNotifications) throws GitLabApiException {
        GitLabApiForm formData = slackNotifications.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "slack");
        return (SlackService)response.readEntity(SlackService.class);
    }

    public void deleteSlackService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "slack");
    }

    public JiraService getJiraService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "jira");
        return (JiraService)response.readEntity(JiraService.class);
    }

    public JiraService updateJiraService(Object projectIdOrPath, JiraService jira) throws GitLabApiException {
        GitLabApiForm formData = jira.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "jira");
        return (JiraService)response.readEntity(JiraService.class);
    }

    public void deleteJiraService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "jira");
    }

    public ExternalWikiService getExternalWikiService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "external-wiki");
        return (ExternalWikiService)response.readEntity(ExternalWikiService.class);
    }

    public ExternalWikiService updateExternalWikiService(Object projectIdOrPath, ExternalWikiService externalWiki) throws GitLabApiException {
        GitLabApiForm formData = externalWiki.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "external-wiki");
        return (ExternalWikiService)response.readEntity(ExternalWikiService.class);
    }

    public void deleteExternalWikiService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "external-wiki");
    }

    public MattermostService getMattermostService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "mattermost");
        return (MattermostService)response.readEntity(MattermostService.class);
    }

    public MattermostService updateMattermostService(Object projectIdOrPath, MattermostService mattermostNotifications) throws GitLabApiException {
        GitLabApiForm formData = mattermostNotifications.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "mattermost");
        return (MattermostService)response.readEntity(MattermostService.class);
    }

    public void deleteMattermostService(Object projectIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "mattermost");
    }

    public BugzillaService getBugzillaService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "bugzilla");
        return (BugzillaService)response.readEntity(BugzillaService.class);
    }

    public BugzillaService updateBugzillaService(Object projectIdOrPath, BugzillaService bugzillaService) throws GitLabApiException {
        GitLabApiForm formData = bugzillaService.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "bugzilla");
        return (BugzillaService)response.readEntity(BugzillaService.class);
    }

    public void deleteBugzillaService(Object projectIdOrPath) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "bugzilla");
    }

    public CustomIssueTrackerService getCustomIssueTrackerService(Object projectIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "custom-issue-tracker");
        return (CustomIssueTrackerService)response.readEntity(CustomIssueTrackerService.class);
    }

    public CustomIssueTrackerService updateCustomIssueTrackerService(Object projectIdOrPath, CustomIssueTrackerService customIssueTracker) throws GitLabApiException {
        GitLabApiForm formData = customIssueTracker.servicePropertiesForm();
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "custom-issue-tracker");
        return (CustomIssueTrackerService)response.readEntity(CustomIssueTrackerService.class);
    }

    public void deleteCustomIssueTrackerService(Object projectIdOrPath) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "services", "custom-issue-tracker");
    }
}

