/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.util.JSONUtil;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

class TimingsExport
extends Thread {
    private final CommandSender sender;
    private final Map out;
    private final TimingHistory[] history;

    TimingsExport(CommandSender sender, Map out, TimingHistory[] history) {
        super("Timings paste thread");
        this.sender = sender;
        this.out = out;
        this.history = history;
    }

    static void reportTimings(CommandSender sender) {
        Map parent = JSONUtil.createObject(JSONUtil.pair("version", (Object)Bukkit.getVersion()), JSONUtil.pair("maxplayers", (Object)Bukkit.getMaxPlayers()), JSONUtil.pair("start", (Object)(TimingsManager.timingStart / 1000L)), JSONUtil.pair("end", (Object)(System.currentTimeMillis() / 1000L)), JSONUtil.pair("sampletime", (Object)((System.currentTimeMillis() - TimingsManager.timingStart) / 1000L)));
        if (!TimingsManager.privacy) {
            JSONUtil.appendObjectData(parent, JSONUtil.pair("server", (Object)Bukkit.getServerName()), JSONUtil.pair("motd", (Object)Bukkit.getServer().getMotd()), JSONUtil.pair("online-mode", (Object)Bukkit.getServer().getOnlineMode()), JSONUtil.pair("icon", (Object)Bukkit.getServer().getServerIcon().getData()));
        }
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        parent.put("system", JSONUtil.createObject(JSONUtil.pair("timingcost", (Object)TimingsExport.getCost()), JSONUtil.pair("name", (Object)System.getProperty("os.name")), JSONUtil.pair("version", (Object)System.getProperty("os.version")), JSONUtil.pair("jvmversion", (Object)System.getProperty("java.version")), JSONUtil.pair("arch", (Object)System.getProperty("os.arch")), JSONUtil.pair("maxmem", (Object)runtime.maxMemory()), JSONUtil.pair("cpu", (Object)runtime.availableProcessors()), JSONUtil.pair("runtime", (Object)ManagementFactory.getRuntimeMXBean().getUptime()), JSONUtil.pair("flags", (Object)StringUtils.join(runtimeBean.getInputArguments(), (String)" ")), JSONUtil.pair("gc", (Object)JSONUtil.toObjectMapper(ManagementFactory.getGarbageCollectorMXBeans(), new Function<GarbageCollectorMXBean, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(GarbageCollectorMXBean input) {
                return JSONUtil.pair(input.getName(), (Object)JSONUtil.toArray(input.getCollectionCount(), input.getCollectionTime()));
            }
        }))));
        HashSet tileEntityTypeSet = Sets.newHashSet();
        HashSet entityTypeSet = Sets.newHashSet();
        int size = TimingsManager.HISTORY.size();
        TimingHistory[] history = new TimingHistory[size + 1];
        int i = 0;
        for (TimingHistory timingHistory : TimingsManager.HISTORY) {
            tileEntityTypeSet.addAll(timingHistory.tileEntityTypeSet);
            entityTypeSet.addAll(timingHistory.entityTypeSet);
            history[i++] = timingHistory;
        }
        history[i] = new TimingHistory();
        tileEntityTypeSet.addAll(history[i].tileEntityTypeSet);
        entityTypeSet.addAll(history[i].entityTypeSet);
        Map handlers = JSONUtil.createObject(new JSONUtil.JSONPair[0]);
        for (TimingIdentifier.TimingGroup group : TimingIdentifier.GROUP_MAP.values()) {
            for (TimingHandler id : group.handlers) {
                if (!id.timed && !id.isSpecial()) continue;
                handlers.put(id.id, JSONUtil.toArray(group.id, id.name));
            }
        }
        parent.put("idmap", JSONUtil.createObject(JSONUtil.pair("groups", (Object)JSONUtil.toObjectMapper(TimingIdentifier.GROUP_MAP.values(), new Function<TimingIdentifier.TimingGroup, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(TimingIdentifier.TimingGroup group) {
                return JSONUtil.pair(group.id, (Object)group.name);
            }
        })), JSONUtil.pair("handlers", (Object)handlers), JSONUtil.pair("worlds", (Object)JSONUtil.toObjectMapper(TimingHistory.worldMap.entrySet(), new Function<Map.Entry<String, Integer>, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(Map.Entry<String, Integer> input) {
                return JSONUtil.pair(input.getValue().intValue(), (Object)input.getKey());
            }
        })), JSONUtil.pair("tileentity", (Object)JSONUtil.toObjectMapper(tileEntityTypeSet, new Function<Material, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(Material input) {
                return JSONUtil.pair(input.getId(), (Object)input.name());
            }
        })), JSONUtil.pair("entity", (Object)JSONUtil.toObjectMapper(entityTypeSet, new Function<EntityType, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(EntityType input) {
                return JSONUtil.pair(input.getTypeId(), (Object)input.name());
            }
        }))));
        parent.put("plugins", JSONUtil.toObjectMapper(Bukkit.getPluginManager().getPlugins(), new Function<Plugin, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(Plugin plugin) {
                return JSONUtil.pair(plugin.getName(), (Object)JSONUtil.createObject(JSONUtil.pair("version", (Object)plugin.getDescription().getVersion()), JSONUtil.pair("description", (Object)String.valueOf(plugin.getDescription().getDescription()).trim()), JSONUtil.pair("website", (Object)plugin.getDescription().getWebsite()), JSONUtil.pair("authors", (Object)StringUtils.join(plugin.getDescription().getAuthors(), (String)", "))));
            }
        }));
        parent.put("config", JSONUtil.createObject(JSONUtil.pair("spigot", (Object)TimingsExport.mapAsJSON(Bukkit.spigot().getSpigotConfig(), null)), JSONUtil.pair("bukkit", (Object)TimingsExport.mapAsJSON(Bukkit.spigot().getBukkitConfig(), null)), JSONUtil.pair("paperspigot", (Object)TimingsExport.mapAsJSON(Bukkit.spigot().getPaperSpigotConfig(), null))));
        new TimingsExport(sender, parent, history).start();
    }

    static long getCost() {
        int passes = 100;
        TimingHandler SAMPLER1 = Timings.ofSafe("Timings Sampler 1");
        TimingHandler SAMPLER2 = Timings.ofSafe("Timings Sampler 2");
        TimingHandler SAMPLER3 = Timings.ofSafe("Timings Sampler 3");
        TimingHandler SAMPLER4 = Timings.ofSafe("Timings Sampler 4");
        TimingHandler SAMPLER5 = Timings.ofSafe("Timings Sampler 5");
        TimingHandler SAMPLER6 = Timings.ofSafe("Timings Sampler 6");
        long start = System.nanoTime();
        int i = 0;
        while (i < passes) {
            SAMPLER1.startTiming();
            SAMPLER2.startTiming();
            SAMPLER3.startTiming();
            SAMPLER3.stopTiming();
            SAMPLER4.startTiming();
            SAMPLER5.startTiming();
            SAMPLER6.startTiming();
            SAMPLER6.stopTiming();
            SAMPLER5.stopTiming();
            SAMPLER4.stopTiming();
            SAMPLER2.stopTiming();
            SAMPLER1.stopTiming();
            ++i;
        }
        long timingsCost = (System.nanoTime() - start) / (long)passes / 6L;
        SAMPLER1.reset(true);
        SAMPLER2.reset(true);
        SAMPLER3.reset(true);
        SAMPLER4.reset(true);
        SAMPLER5.reset(true);
        SAMPLER6.reset(true);
        return timingsCost;
    }

    private static JSONObject mapAsJSON(ConfigurationSection config, String parentKey) {
        JSONObject object = new JSONObject();
        for (String key : config.getKeys(false)) {
            String fullKey;
            String string = fullKey = parentKey != null ? String.valueOf(parentKey) + "." + key : key;
            if (fullKey.equals("database") || fullKey.equals("settings.bungeecord-addresses") || TimingsManager.hiddenConfigs.contains(fullKey)) continue;
            Object val = config.get(key);
            object.put((Object)key, TimingsExport.valAsJSON(val, fullKey));
        }
        return object;
    }

    private static Object valAsJSON(Object val, final String parentKey) {
        if (!(val instanceof MemorySection)) {
            if (val instanceof List) {
                Iterable v = (Iterable)val;
                return JSONUtil.toArrayMapper(v, new Function<Object, Object>(){

                    public Object apply(Object input) {
                        return TimingsExport.valAsJSON(input, parentKey);
                    }
                });
            }
            return val.toString();
        }
        return TimingsExport.mapAsJSON((ConfigurationSection)val, parentKey);
    }

    @Override
    public synchronized void start() {
        if (this.sender instanceof RemoteConsoleCommandSender) {
            this.sender.sendMessage((Object)((Object)ChatColor.RED) + "Warning: Timings report done over RCON will cause lag spikes.");
            this.sender.sendMessage((Object)((Object)ChatColor.RED) + "You should use " + (Object)((Object)ChatColor.YELLOW) + "/timings report" + (Object)((Object)ChatColor.RED) + " in game or console.");
            this.run();
        } else {
            super.start();
        }
    }

    @Override
    public void run() {
        this.sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Preparing Timings Report...");
        this.out.put("data", JSONUtil.toArrayMapper(this.history, new Function<TimingHistory, Object>(){

            public Object apply(TimingHistory input) {
                return input.export();
            }
        }));
        String response = null;
        try {
            HttpURLConnection con = (HttpURLConnection)new URL("http://timings.aikar.co/post").openConnection();
            con.setDoOutput(true);
            con.setRequestProperty("User-Agent", "Spigot/" + Bukkit.getServerName() + "/" + InetAddress.getLocalHost().getHostName());
            con.setRequestMethod("POST");
            con.setInstanceFollowRedirects(false);
            GZIPOutputStream request = new GZIPOutputStream(con.getOutputStream()){
                {
                    this.def.setLevel(7);
                }
            };
            ((OutputStream)request).write(JSONValue.toJSONString((Object)this.out).getBytes("UTF-8"));
            ((OutputStream)request).close();
            response = this.getResponse(con);
            if (con.getResponseCode() != 302) {
                this.sender.sendMessage((Object)((Object)ChatColor.RED) + "Upload Error: " + con.getResponseCode() + ": " + con.getResponseMessage());
                this.sender.sendMessage((Object)((Object)ChatColor.RED) + "Check your logs for more information");
                if (response != null) {
                    Bukkit.getLogger().log(Level.SEVERE, response);
                }
                return;
            }
            String location = con.getHeaderField("Location");
            this.sender.sendMessage((Object)((Object)ChatColor.GREEN) + "View Timings Report: " + location);
            if (!(this.sender instanceof ConsoleCommandSender)) {
                Bukkit.getLogger().log(Level.INFO, "View Timings Report: " + location);
            }
            if (response != null && !response.isEmpty()) {
                Bukkit.getLogger().log(Level.INFO, "Timing Response: " + response);
            }
        }
        catch (IOException ex) {
            this.sender.sendMessage((Object)((Object)ChatColor.RED) + "Error uploading timings, check your logs for more information");
            if (response != null) {
                Bukkit.getLogger().log(Level.SEVERE, response);
            }
            Bukkit.getLogger().log(Level.SEVERE, "Could not paste timings", ex);
        }
    }

    private String getResponse(HttpURLConnection con) throws IOException {
        try (InputStream is = null;){
            int bytesRead;
            is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((bytesRead = is.read(b)) != -1) {
                bos.write(b, 0, bytesRead);
            }
            String string = bos.toString();
            return string;
        }
    }
}

