/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsExport;
import co.aikar.timings.TimingsManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.util.StringUtil;

public class TimingsCommand
extends BukkitCommand {
    public static final List<String> TIMINGS_SUBCOMMANDS = ImmutableList.of((Object)"report", (Object)"reset", (Object)"on", (Object)"off", (Object)"paste", (Object)"verbon", (Object)"verboff");

    public TimingsCommand(String name) {
        super(name);
        this.description = "Manages Spigot Timings data to see performance of the server.";
        this.usageMessage = "/timings <reset|report|on|off|verbon|verboff>";
        this.setPermission("bukkit.command.timings");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return true;
        }
        String arg = args[0];
        if ("on".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(true);
            sender.sendMessage("Enabled Timings & Reset");
            return true;
        }
        if ("off".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(false);
            sender.sendMessage("Disabled Timings");
            return true;
        }
        if (!Timings.isTimingsEnabled()) {
            sender.sendMessage("Please enable timings by typing /timings on");
            return true;
        }
        if ("verbon".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(true);
            sender.sendMessage("Enabled Verbose Timings");
            return true;
        }
        if ("verboff".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(false);
            sender.sendMessage("Disabled Verbose Timings");
            return true;
        }
        if ("reset".equalsIgnoreCase(arg)) {
            TimingsManager.reset();
            sender.sendMessage("Timings reset");
        } else if ("cost".equals(arg)) {
            sender.sendMessage("Timings cost: " + TimingsExport.getCost());
        } else if ("paste".equalsIgnoreCase(arg) || "report".equalsIgnoreCase(arg) || "get".equalsIgnoreCase(arg) || "merged".equalsIgnoreCase(arg) || "separate".equalsIgnoreCase(arg)) {
            TimingsExport.reportTimings(sender);
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], TIMINGS_SUBCOMMANDS, new ArrayList(TIMINGS_SUBCOMMANDS.size()));
        }
        return ImmutableList.of();
    }
}

