/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimingData;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistoryEntry;
import co.aikar.timings.TimingsManager;
import co.aikar.util.JSONUtil;
import co.aikar.util.LoadingMap;
import co.aikar.util.MRUMapCache;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;

public class TimingHistory {
    public static long lastMinuteTime;
    public static long timedTicks;
    public static long playerTicks;
    public static long entityTicks;
    public static long tileEntityTicks;
    public static long activatedEntityTicks;
    static int worldIdPool;
    static Map<String, Integer> worldMap;
    final long endTime;
    final long startTime;
    final long totalTicks;
    final long totalTime;
    final MinuteReport[] minuteReports;
    final TimingHistoryEntry[] entries;
    final Set<Material> tileEntityTypeSet = Sets.newHashSet();
    final Set<EntityType> entityTypeSet = Sets.newHashSet();
    final Map<Object, Object> worlds;

    static {
        worldIdPool = 1;
        worldMap = LoadingMap.newHashMap(new Function<String, Integer>(){

            public Integer apply(String input) {
                return worldIdPool++;
            }
        });
    }

    TimingHistory() {
        this.endTime = System.currentTimeMillis() / 1000L;
        this.startTime = TimingsManager.historyStart / 1000L;
        if (timedTicks % 1200L != 0L || TimingsManager.MINUTE_REPORTS.isEmpty()) {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size() + 1]);
            this.minuteReports[this.minuteReports.length - 1] = new MinuteReport();
        } else {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size()]);
        }
        long ticks = 0L;
        MinuteReport[] minuteReportArray = this.minuteReports;
        int n = this.minuteReports.length;
        int n2 = 0;
        while (n2 < n) {
            MinuteReport mp = minuteReportArray[n2];
            ticks += mp.ticksRecord.timed;
            ++n2;
        }
        this.totalTicks = ticks;
        this.totalTime = TimingsManager.FULL_SERVER_TICK.record.totalTime;
        this.entries = new TimingHistoryEntry[TimingsManager.HANDLERS.size()];
        int i = 0;
        for (TimingHandler handler : TimingsManager.HANDLERS) {
            this.entries[i++] = new TimingHistoryEntry(handler);
        }
        final Map entityCounts = MRUMapCache.of(LoadingMap.of(new EnumMap(EntityType.class), Counter.LOADER));
        final Map tileEntityCounts = MRUMapCache.of(LoadingMap.of(new EnumMap(Material.class), Counter.LOADER));
        this.worlds = JSONUtil.toObjectMapper(Bukkit.getWorlds(), new Function<World, JSONUtil.JSONPair>(){

            public JSONUtil.JSONPair apply(World world) {
                return JSONUtil.pair(worldMap.get(world.getName()).intValue(), (Object)JSONUtil.toArrayMapper(world.getLoadedChunks(), new Function<Chunk, Object>(){

                    public Object apply(Chunk chunk) {
                        entityCounts.clear();
                        tileEntityCounts.clear();
                        Metadatable[] metadatableArray = chunk.getEntities();
                        int n = metadatableArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Entity entity = metadatableArray[n2];
                            ((Counter)entityCounts.get((Object)entity.getType())).increment();
                            ++n2;
                        }
                        metadatableArray = chunk.getTileEntities();
                        n = metadatableArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            Metadatable tileEntity = metadatableArray[n2];
                            ((Counter)tileEntityCounts.get((Object)tileEntity.getBlock().getType())).increment();
                            ++n2;
                        }
                        if (tileEntityCounts.isEmpty() && entityCounts.isEmpty()) {
                            return null;
                        }
                        return JSONUtil.toArray(chunk.getX(), chunk.getZ(), JSONUtil.toObjectMapper(entityCounts.entrySet(), new Function<Map.Entry<EntityType, Counter>, JSONUtil.JSONPair>(){

                            public JSONUtil.JSONPair apply(Map.Entry<EntityType, Counter> entry) {
                                ((this).this).TimingHistory.this.entityTypeSet.add(entry.getKey());
                                return JSONUtil.pair(String.valueOf(entry.getKey().getTypeId()), (Object)entry.getValue().count());
                            }
                        }), JSONUtil.toObjectMapper(tileEntityCounts.entrySet(), new Function<Map.Entry<Material, Counter>, JSONUtil.JSONPair>(){

                            public JSONUtil.JSONPair apply(Map.Entry<Material, Counter> entry) {
                                ((this).this).TimingHistory.this.tileEntityTypeSet.add(entry.getKey());
                                return JSONUtil.pair(String.valueOf(entry.getKey().getId()), (Object)entry.getValue().count());
                            }
                        }));
                    }
                }));
            }
        });
    }

    public static void resetTicks(boolean fullReset) {
        if (fullReset) {
            timedTicks = 0L;
        }
        lastMinuteTime = System.nanoTime();
        playerTicks = 0L;
        tileEntityTicks = 0L;
        entityTicks = 0L;
        activatedEntityTicks = 0L;
    }

    Object export() {
        return JSONUtil.createObject(JSONUtil.pair("s", (Object)this.startTime), JSONUtil.pair("e", (Object)this.endTime), JSONUtil.pair("tk", (Object)this.totalTicks), JSONUtil.pair("tm", (Object)this.totalTime), JSONUtil.pair("w", this.worlds), JSONUtil.pair("h", (Object)JSONUtil.toArrayMapper(this.entries, new Function<TimingHistoryEntry, Object>(){

            public Object apply(TimingHistoryEntry entry) {
                TimingData record = entry.data;
                if (record.count == 0) {
                    return null;
                }
                return entry.export();
            }
        })), JSONUtil.pair("mp", (Object)JSONUtil.toArrayMapper(this.minuteReports, new Function<MinuteReport, Object>(){

            public Object apply(MinuteReport input) {
                return input.export();
            }
        })));
    }

    static class Counter {
        int count = 0;
        static Function LOADER = new LoadingMap.Feeder<Counter>(){

            @Override
            public Counter apply() {
                return new Counter();
            }
        };

        Counter() {
        }

        public int increment() {
            return ++this.count;
        }

        public int count() {
            return this.count;
        }
    }

    static class MinuteReport {
        final long time = System.currentTimeMillis() / 1000L;
        final TicksRecord ticksRecord = new TicksRecord();
        final PingRecord pingRecord = new PingRecord();
        final TimingData fst;
        final double tps;
        final double usedMemory;
        final double freeMemory;
        final double loadAvg;

        MinuteReport() {
            this.fst = TimingsManager.FULL_SERVER_TICK.minuteData.clone();
            this.tps = 1.0E9 / (double)(System.nanoTime() - lastMinuteTime) * (double)this.ticksRecord.timed;
            this.usedMemory = TimingsManager.FULL_SERVER_TICK.avgUsedMemory;
            this.freeMemory = TimingsManager.FULL_SERVER_TICK.avgFreeMemory;
            this.loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }

        public List export() {
            return JSONUtil.toArray(this.time, (double)Math.round(this.tps * 100.0) / 100.0, (double)Math.round(this.pingRecord.avg * 100.0) / 100.0, this.fst.export(), JSONUtil.toArray(this.ticksRecord.timed, this.ticksRecord.player, this.ticksRecord.entity, this.ticksRecord.activatedEntity, this.ticksRecord.tileEntity), this.usedMemory, this.freeMemory, this.loadAvg);
        }
    }

    static class PingRecord {
        final double avg;

        PingRecord() {
            Collection<? extends Player> onlinePlayers = Bukkit.getOnlinePlayers();
            int totalPing = 0;
            for (Player player : onlinePlayers) {
                totalPing += player.spigot().getPing();
            }
            this.avg = onlinePlayers.isEmpty() ? 0 : totalPing / onlinePlayers.size();
        }
    }

    static class TicksRecord {
        final long timed = timedTicks - (long)(TimingsManager.MINUTE_REPORTS.size() * 1200);
        final long player = playerTicks;
        final long entity = entityTicks;
        final long tileEntity = tileEntityTicks;
        final long activatedEntity = activatedEntityTicks;

        TicksRecord() {
        }
    }
}

