/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingData;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.util.LoadingIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;

class TimingHandler
implements Timing {
    private static int idPool = 1;
    final int id = idPool++;
    final String name;
    final boolean verbose;
    final TIntObjectHashMap<TimingData> children = new LoadingIntMap<TimingData>(TimingData.LOADER);
    final TimingData record;
    final TimingHandler groupHandler;
    long start = 0L;
    int timingDepth = 0;
    boolean added;
    boolean timed;
    boolean enabled;
    TimingHandler parent;

    TimingHandler(TimingIdentifier id) {
        if (id.name.startsWith("##")) {
            this.verbose = true;
            this.name = id.name.substring(3);
        } else {
            this.name = id.name;
            this.verbose = false;
        }
        this.record = new TimingData(this.id);
        this.groupHandler = id.groupHandler;
        TimingIdentifier.getGroup((String)id.group).handlers.add(this);
        this.checkEnabled();
    }

    final void checkEnabled() {
        this.enabled = Timings.timingsEnabled && (!this.verbose || Timings.verboseEnabled);
    }

    void processTick(boolean violated) {
        if (this.timingDepth != 0 || this.record.curTickCount == 0) {
            this.timingDepth = 0;
            this.start = 0L;
            return;
        }
        this.record.processTick(violated);
        for (TimingData handler : this.children.valueCollection()) {
            handler.processTick(violated);
        }
    }

    @Override
    public void startTimingIfSync() {
        if (Bukkit.isPrimaryThread()) {
            this.startTiming();
        }
    }

    @Override
    public void stopTimingIfSync() {
        if (Bukkit.isPrimaryThread()) {
            this.stopTiming();
        }
    }

    @Override
    public void startTiming() {
        if (this.enabled && ++this.timingDepth == 1) {
            this.start = System.nanoTime();
            this.parent = TimingsManager.CURRENT;
            TimingsManager.CURRENT = this;
        }
    }

    @Override
    public void stopTiming() {
        if (this.enabled && --this.timingDepth == 0 && this.start != 0L) {
            if (!Bukkit.isPrimaryThread()) {
                Bukkit.getLogger().log(Level.SEVERE, "stopTiming called async for " + this.name);
                new Throwable().printStackTrace();
                this.start = 0L;
                return;
            }
            this.addDiff(System.nanoTime() - this.start);
            this.start = 0L;
        }
    }

    @Override
    public void abort() {
        if (this.enabled && this.timingDepth > 0) {
            this.start = 0L;
        }
    }

    void addDiff(long diff) {
        if (TimingsManager.CURRENT == this) {
            TimingsManager.CURRENT = this.parent;
            if (this.parent != null) {
                ((TimingData)this.parent.children.get(this.id)).add(diff);
            }
        }
        this.record.add(diff);
        if (!this.added) {
            this.added = true;
            this.timed = true;
            TimingsManager.HANDLERS.add(this);
        }
        if (this.groupHandler != null) {
            this.groupHandler.addDiff(diff);
            ((TimingData)this.groupHandler.children.get(this.id)).add(diff);
        }
    }

    void reset(boolean full) {
        this.record.reset();
        if (full) {
            this.timed = false;
        }
        this.start = 0L;
        this.timingDepth = 0;
        this.added = false;
        this.children.clear();
        this.checkEnabled();
    }

    @Override
    public TimingHandler getTimingHandler() {
        return this;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public void close() {
        this.stopTimingIfSync();
    }

    public boolean isSpecial() {
        return this == TimingsManager.FULL_SERVER_TICK || this == TimingsManager.TIMINGS_TICK;
    }
}

