/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.util.JSONUtil;
import com.google.common.base.Function;
import java.util.List;

class TimingData {
    static Function<Integer, TimingData> LOADER = new Function<Integer, TimingData>(){

        public TimingData apply(Integer input) {
            return new TimingData(input);
        }
    };
    int id;
    int count = 0;
    int lagCount = 0;
    long totalTime = 0L;
    long lagTotalTime = 0L;
    int curTickCount = 0;
    int curTickTotal = 0;

    TimingData(int id) {
        this.id = id;
    }

    TimingData(TimingData data) {
        this.id = data.id;
        this.totalTime = data.totalTime;
        this.lagTotalTime = data.lagTotalTime;
        this.count = data.count;
        this.lagCount = data.lagCount;
    }

    void add(long diff) {
        ++this.curTickCount;
        this.curTickTotal = (int)((long)this.curTickTotal + diff);
    }

    void processTick(boolean violated) {
        this.totalTime += (long)this.curTickTotal;
        this.count += this.curTickCount;
        if (violated) {
            this.lagTotalTime += (long)this.curTickTotal;
            this.lagCount += this.curTickCount;
        }
        this.curTickTotal = 0;
        this.curTickCount = 0;
    }

    void reset() {
        this.count = 0;
        this.lagCount = 0;
        this.curTickTotal = 0;
        this.curTickCount = 0;
        this.totalTime = 0L;
        this.lagTotalTime = 0L;
    }

    protected TimingData clone() {
        return new TimingData(this);
    }

    public List export() {
        List list = JSONUtil.toArray(this.id, this.count, this.totalTime);
        if (this.lagCount > 0) {
            list.add(this.lagCount);
            list.add(this.lagTotalTime);
        }
        return list;
    }
}

