/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.C2D;
import org.geolatte.geom.C2DM;
import org.geolatte.geom.C3D;
import org.geolatte.geom.C3DM;
import org.geolatte.geom.G2D;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.AngularUnit;
import org.geolatte.geom.crs.CartesianCoordinateSystem2D;
import org.geolatte.geom.crs.CompoundCoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem2D;
import org.geolatte.geom.crs.GeodeticLatitudeCSAxis;
import org.geolatte.geom.crs.GeodeticLongitudeCSAxis;
import org.geolatte.geom.crs.Geographic2DCoordinateReferenceSystem;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.SingleCoordinateReferenceSystem;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.Unit;
import org.geolatte.geom.crs.VerticalCoordinateReferenceSystem;
import org.geolatte.geom.crs.VerticalDatum;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class CoordinateReferenceSystems {
    public static final SingleCoordinateReferenceSystem<C2D> PROJECTED_2D_METER = CoordinateReferenceSystems.mkProjected(Unit.METER);
    public static final CompoundCoordinateReferenceSystem<C2DM> PROJECTED_2DM_METER = CoordinateReferenceSystems.addLinearSystem(PROJECTED_2D_METER, C2DM.class, Unit.METER);
    public static final CompoundCoordinateReferenceSystem<C3D> PROJECTED_3D_METER = CoordinateReferenceSystems.addVerticalSystem(PROJECTED_2D_METER, C3D.class, Unit.METER);
    public static final CompoundCoordinateReferenceSystem<C3DM> PROJECTED_3DM_METER = CoordinateReferenceSystems.addLinearSystem(PROJECTED_3D_METER, C3DM.class, Unit.METER);
    public static Geographic2DCoordinateReferenceSystem WGS84 = CrsRegistry.getGeographicCoordinateReferenceSystemForEPSG(4326);
    public static ProjectedCoordinateReferenceSystem WEB_MERCATOR = CrsRegistry.getProjectedCoordinateReferenceSystemForEPSG(3857);
    public static GeographicCoordinateReferenceSystem<G2D> ETRS89 = CrsRegistry.getGeographicCoordinateReferenceSystemForEPSG(4258);

    public static ProjectedCoordinateReferenceSystem mkProjected(CrsId srid, LinearUnit unit) {
        return new ProjectedCoordinateReferenceSystem(srid, "Generic 2D Projected", CoordinateReferenceSystems.mkGeographic(Unit.DEGREE), Projection.UNKNOWN, new ArrayList<CrsParameter>(), new CartesianCoordinateSystem2D(new StraightLineAxis("X", CoordinateSystemAxisDirection.EAST, unit), new StraightLineAxis("Y", CoordinateSystemAxisDirection.NORTH, unit)));
    }

    public static ProjectedCoordinateReferenceSystem mkProjected(LinearUnit unit) {
        return CoordinateReferenceSystems.mkProjected(CrsId.UNDEFINED, unit);
    }

    public static GeographicCoordinateReferenceSystem mkGeographic(CrsId srid, AngularUnit unit) {
        return new Geographic2DCoordinateReferenceSystem(srid, "Generic 2D Geographic", new EllipsoidalCoordinateSystem2D(new GeodeticLatitudeCSAxis("Lat", unit), new GeodeticLongitudeCSAxis("Lon", unit)));
    }

    public static GeographicCoordinateReferenceSystem mkGeographic(AngularUnit unit) {
        return CoordinateReferenceSystems.mkGeographic(CrsId.UNDEFINED, unit);
    }

    public static CoordinateReferenceSystem<?> mkCoordinateReferenceSystem(CoordinateReferenceSystem<?> baseCrs, LinearUnit verticalUnit, LinearUnit measureUnit) {
        CoordinateReferenceSystem<?> result = baseCrs;
        if (verticalUnit != null && !CoordinateReferenceSystems.hasVerticalAxis(baseCrs)) {
            result = CoordinateReferenceSystems.addVerticalSystem(result, verticalUnit);
        }
        if (measureUnit != null && !CoordinateReferenceSystems.hasMeasureAxis(baseCrs)) {
            result = CoordinateReferenceSystems.addLinearSystem(result, measureUnit);
        }
        return result;
    }

    public static CoordinateReferenceSystem<?> mkCoordinateReferenceSystem(int epsgCode, LinearUnit verticalUnit, LinearUnit measureUnit) {
        return CoordinateReferenceSystems.mkCoordinateReferenceSystem(CrsRegistry.getCoordinateReferenceSystemForEPSG(epsgCode, PROJECTED_2D_METER), verticalUnit, measureUnit);
    }

    public static <P extends Position> CoordinateReferenceSystem<P> mkCoordinateReferenceSystem(CoordinateReferenceSystem<?> baseCrs, LinearUnit verticalUnit, LinearUnit measureUnit, Class<P> positionType) {
        CoordinateReferenceSystem<?> crs = CoordinateReferenceSystems.mkCoordinateReferenceSystem(baseCrs, verticalUnit, measureUnit);
        if (crs.getPositionClass().equals(positionType)) {
            return crs;
        }
        throw new IllegalArgumentException(String.format("Invalid positionClass: %s not equals %s", crs.getPositionClass().getName(), positionType.getName()));
    }

    public static LinearCoordinateReferenceSystem mkLinear(LinearUnit unit) {
        return new LinearCoordinateReferenceSystem("measure", new MeasureStraightLineAxis("M", unit));
    }

    public static VerticalCoordinateReferenceSystem mkVertical(LinearUnit unit) {
        return new VerticalCoordinateReferenceSystem(CrsId.UNDEFINED, "vertical", VerticalDatum.UNKNOWN_VERTICAL_DATUM, new VerticalStraightLineAxis("Z", unit));
    }

    public static <P extends Position, R extends Position> CompoundCoordinateReferenceSystem<R> combine(CoordinateReferenceSystem<P> base, SingleCoordinateReferenceSystem ods, Class<R> resultCSPtype) {
        CompoundCoordinateReferenceSystem<?> result = CoordinateReferenceSystems.combine(base, ods);
        if (!result.getPositionClass().equals(resultCSPtype)) {
            throw new IllegalArgumentException("Specified Position class inconsistent with result");
        }
        return result;
    }

    public static <P extends Position, R extends Position> CompoundCoordinateReferenceSystem<R> addLinearSystem(CoordinateReferenceSystem<P> base, Class<R> resultCSPtype, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkLinear(unit), resultCSPtype);
    }

    public static <P extends Position, R extends Position> CompoundCoordinateReferenceSystem<R> addVerticalSystem(CoordinateReferenceSystem<P> base, Class<R> resultCSPtype, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkVertical(unit), resultCSPtype);
    }

    public static <P extends Position> ProjectedCoordinateReferenceSystem asProjected(CoordinateReferenceSystem<P> original) {
        return new ProjectedCoordinateReferenceSystem(original.getCrsId(), original.getName(), WGS84, Projection.NOOP, new ArrayList<CrsParameter>(), CartesianCoordinateSystem2D.DEFAULT);
    }

    public static <P extends Position> CompoundCoordinateReferenceSystem<?> combine(CoordinateReferenceSystem<P> base, SingleCoordinateReferenceSystem ods) {
        if (base instanceof CompoundCoordinateReferenceSystem) {
            List<SingleCoordinateReferenceSystem<?>> components = ((CompoundCoordinateReferenceSystem)base).getComponents();
            ArrayList nc = new ArrayList(components);
            nc.add(ods);
            return new CompoundCoordinateReferenceSystem(base.getName() + "+" + ods.getName(), nc.toArray(new SingleCoordinateReferenceSystem[0]));
        }
        if (base instanceof SingleCoordinateReferenceSystem) {
            SingleCoordinateReferenceSystem single = (SingleCoordinateReferenceSystem)base;
            return new CompoundCoordinateReferenceSystem(single.getName() + "+" + ods.getName(), single, ods);
        }
        throw new UnsupportedOperationException("Unsupported type of coordinate reference system");
    }

    public static <P extends Position> CompoundCoordinateReferenceSystem<?> addLinearSystem(CoordinateReferenceSystem<P> base, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkLinear(unit));
    }

    public static <P extends Position> CompoundCoordinateReferenceSystem<?> addVerticalSystem(CoordinateReferenceSystem<P> base, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkVertical(unit));
    }

    public static CoordinateReferenceSystem<?> adjustTo(CoordinateReferenceSystem<?> crs, boolean hasZ, boolean hasM) {
        if (!hasZ && !hasM) {
            return crs;
        }
        CrsId extId = crs.getCrsId().extend(hasZ ? Unit.METER : null, hasM ? Unit.METER : null);
        return CrsRegistry.computeIfAbsent(extId, key -> CoordinateReferenceSystems.mkCoordinateReferenceSystem(crs, hasZ ? Unit.METER : null, hasM ? Unit.METER : null));
    }

    public static CoordinateReferenceSystem<?> adjustTo(CoordinateReferenceSystem<?> crs, int coordinateDimension) {
        return CoordinateReferenceSystems.adjustTo(crs, coordinateDimension, false);
    }

    public static CoordinateReferenceSystem<?> adjustTo(CoordinateReferenceSystem<?> crs, int coordinateDimension, boolean hasM) {
        if (coordinateDimension <= 2) {
            return crs;
        }
        if (coordinateDimension == 3 && hasM) {
            CrsId extId = crs.getCrsId().extend(null, Unit.METER);
            return CrsRegistry.computeIfAbsent(extId, key -> CoordinateReferenceSystems.mkCoordinateReferenceSystem(crs, null, Unit.METER));
        }
        if (coordinateDimension == 3) {
            CrsId extId = crs.getCrsId().extend(Unit.METER, null);
            return CrsRegistry.computeIfAbsent(extId, key -> CoordinateReferenceSystems.mkCoordinateReferenceSystem(crs, Unit.METER, null));
        }
        if (coordinateDimension == 4) {
            CrsId extId = crs.getCrsId().extend(Unit.METER, Unit.METER);
            return CrsRegistry.computeIfAbsent(extId, key -> CoordinateReferenceSystems.mkCoordinateReferenceSystem(crs, Unit.METER, Unit.METER));
        }
        throw new IllegalStateException("CoordinateDimension " + coordinateDimension + " less than 2 or larger than 4");
    }

    public static <P extends Position> boolean hasAxisOrder(CoordinateReferenceSystem<P> crs, int order) {
        CoordinateSystemAxis[] axes;
        for (CoordinateSystemAxis axis : axes = crs.getCoordinateSystem().getAxes()) {
            if (axis.getNormalOrder() != order) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static <P extends Position> boolean hasVerticalAxis(CoordinateReferenceSystem<P> crs) {
        return crs.hasZ();
    }

    @Deprecated
    public static <P extends Position> boolean hasMeasureAxis(CoordinateReferenceSystem<P> crs) {
        return crs.hasM();
    }
}

