/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;

public class PolygonSdoEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.POLYGON.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        int dim = geom.getCoordinateDimension();
        int lrsPos = this.getLRSDim(geom);
        SDOGType sdogType = new SDOGType(dim, lrsPos, SdoGeometryType.POLYGON);
        SDOGeometry base = new SDOGeometry(sdogType, geom.getSRID(), null, null, null);
        Polygon polygon = (Polygon)geom;
        return this.addPolygon(base, polygon);
    }
}

