/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;

public class MultiPolygonSdoEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.MULTIPOLYGON.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        MultiPolygon multiPolygon = (MultiPolygon)geom;
        int dim = multiPolygon.getCoordinateDimension();
        int lrsPos = this.getLRSDim(multiPolygon);
        SDOGType gType = new SDOGType(dim, lrsPos, SdoGeometryType.MULTIPOLYGON);
        SDOGeometry sdoGeom = new SDOGeometry(gType, geom.getSRID(), null, null, null);
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            try {
                Polygon pg = (Polygon)multiPolygon.getGeometryN(i);
                sdoGeom = this.addPolygon(sdoGeom, pg);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Found geometry that was not a geometry in MultiPolygon", e);
            }
        }
        return sdoGeom;
    }
}

