/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;

public class MultiPointSdoEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.MULTIPOINT.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        int dim = geom.getCoordinateDimension();
        int lrsDim = this.getLRSDim(geom);
        boolean isLrs = lrsDim != 0;
        MultiPoint multiPoint = (MultiPoint)geom;
        ElemInfo info = new ElemInfo(1);
        info.setElement(0, 1, ElementType.POINT, multiPoint.getNumGeometries());
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            ordinates = this.addOrdinates(ordinates, this.pointToOrdinates(multiPoint, i));
        }
        return new SDOGeometry(new SDOGType(dim, lrsDim, SdoGeometryType.MULTIPOINT), geom.getSRID(), null, info, new Ordinates(ordinates));
    }

    private Double[] pointToOrdinates(MultiPoint<?> multiPoint, int i) {
        if (((Point)multiPoint.getGeometryN(i)).isEmpty()) {
            return new Double[0];
        }
        Double[] pointOrdinates = new Double[multiPoint.getCoordinateDimension()];
        int idx = 0;
        for (double d : ((Position)((Point)multiPoint.getGeometryN(i)).getPosition()).toArray(null)) {
            pointOrdinates[idx++] = d;
        }
        return pointOrdinates;
    }
}

