/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.cga.CircularArcLinearizer;

class Linearizer {
    private static final double DEFAULT_EPSILON = 1.0E-4;
    private final double epsilon;

    public Linearizer() {
        this(1.0E-4);
    }

    public Linearizer(double epsilon) {
        this.epsilon = epsilon;
    }

    <P extends Position> List<P> linearizeToList(PositionSequence<P> positions, boolean entireCircle) {
        ArrayList result = new ArrayList();
        int idx = 0;
        while (idx < positions.size() - 2) {
            P p0 = positions.getPositionN(idx++);
            P p1 = positions.getPositionN(idx++);
            P p2 = positions.getPositionN(idx);
            CircularArcLinearizer<P> linearizer = new CircularArcLinearizer<P>(p0, p1, p2, this.epsilon);
            if (entireCircle) {
                result.addAll(linearizer.linearizeCircle().stream().collect(Collectors.toList()));
                continue;
            }
            result.addAll(linearizer.linearize().stream().collect(Collectors.toList()));
        }
        return result;
    }

    <P extends Position> PositionSequence<P> linearize(PositionSequence<P> positions, boolean entireCircle) {
        List<P> linearized = this.linearizeToList(positions, entireCircle);
        PositionSequenceBuilder<P> builder = PositionSequenceBuilders.fixedSized(linearized.size(), positions.getPositionClass());
        builder.addAll(linearized);
        return builder.toPositionSequence();
    }
}

