/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class LineStringSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == SdoGeometryType.LINE;
    }

    @Override
    protected Geometry<?> internalDecode() {
        return this.decode(this.nativeGeom.getGType(), this.nativeGeom.getElements(), this.nativeGeom.getCoordinateReferenceSystem());
    }

    @Override
    protected <P extends Position> Geometry<P> decode(SDOGType gtype, List<Element> elements, CoordinateReferenceSystem<P> crs) {
        assert (elements.size() <= 1);
        return new LineString<P>(elements.get(0).linearizedPositions(gtype, crs), crs);
    }
}

