/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class GeometryCollectionSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == SdoGeometryType.COLLECTION;
    }

    @Override
    Geometry<?> internalDecode() {
        return this.decode(this.nativeGeom.getGType(), this.nativeGeom.getElements(), this.nativeGeom.getCoordinateReferenceSystem());
    }

    @Override
    <P extends Position> Geometry<P> decode(SDOGType parentType, List<Element> elements, CoordinateReferenceSystem<P> crs) {
        ArrayList<Geometry<P>> geometries = new ArrayList<Geometry<P>>();
        int i = 0;
        while (i < elements.size()) {
            Element element = elements.get(i);
            SDOGType gtype = SDOGType.derive(element.getElementType(), parentType);
            assert (gtype != null);
            AbstractSDODecoder decoder = gtype.getTypeGeometry().createDecoder();
            if (element.isExteriorRing()) {
                ArrayList<Element> rings = new ArrayList<Element>();
                rings.add(element);
                for (int k = i + 1; k < elements.size() && (element = elements.get(k)).isInteriorRing(); ++k) {
                    rings.add(element);
                }
                geometries.add(decoder.decode(gtype, rings, crs));
                i += rings.size();
                continue;
            }
            ArrayList<Element> ell = new ArrayList<Element>();
            ell.add(element);
            geometries.add(decoder.decode(gtype, ell, crs));
            ++i;
        }
        Geometry[] geomArray = new Geometry[geometries.size()];
        return new GeometryCollection(geometries.toArray(geomArray));
    }
}

