/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.Encoder;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.GeometryCollectionSdoEncoder;
import org.geolatte.geom.codec.db.oracle.LineStringSdoEncoder;
import org.geolatte.geom.codec.db.oracle.MultiLineStringSdoEncoder;
import org.geolatte.geom.codec.db.oracle.MultiPointSdoEncoder;
import org.geolatte.geom.codec.db.oracle.MultiPolygonSdoEncoder;
import org.geolatte.geom.codec.db.oracle.PointSdoEncoder;
import org.geolatte.geom.codec.db.oracle.PolygonSdoEncoder;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SQLTypeFactory;

public class Encoders {
    private static final List<AbstractSDOEncoder> ENCODERS = new ArrayList<AbstractSDOEncoder>();

    public static Encoder<SDOGeometry> encoderFor(Geometry<?> geom) {
        for (Encoder encoder : ENCODERS) {
            if (!encoder.accepts(geom)) continue;
            return encoder;
        }
        throw new IllegalArgumentException("No encoder for type " + (geom == null ? "NULL" : geom.getGeometryType()));
    }

    public static SDOGeometry encode(Geometry<?> geom) {
        Encoder<SDOGeometry> encoder = Encoders.encoderFor(geom);
        return encoder.encode(geom);
    }

    public static Struct encode(Geometry<?> geom, Connection conn, SQLTypeFactory typeFactory) throws SQLException {
        return typeFactory.createStruct(Encoders.encode(geom), conn);
    }

    static {
        ENCODERS.add(new PointSdoEncoder());
        ENCODERS.add(new LineStringSdoEncoder());
        ENCODERS.add(new PolygonSdoEncoder());
        ENCODERS.add(new MultiPointSdoEncoder());
        ENCODERS.add(new MultiLineStringSdoEncoder());
        ENCODERS.add(new MultiPolygonSdoEncoder());
        ENCODERS.add(new GeometryCollectionSdoEncoder());
    }
}

