/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.cga;

import java.util.stream.IntStream;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;

public class NumericalMethods {
    public static final int ClockWise = 1;
    public static final int CounterClockWise = 2;

    public static double determinant(double a11, double a12, double a21, double a22) {
        TwoSum ts = new TwoSum(a11 * a22, -a12 * a21);
        return ts.estimate + ts.error;
    }

    public static double crossProduct(double x0, double y0, double x1, double y1) {
        return NumericalMethods.determinant(x0, x1, y0, y1);
    }

    public static double determinant(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) {
        TwoSum tl1 = new TwoSum(a11 * a22 * a33, a12 * a23 * a31);
        TwoSum tl2 = new TwoSum(tl1.estimate, a13 * a21 * a32);
        TwoSum tr1 = new TwoSum(a13 * a22 * a31, a12 * a21 * a33);
        TwoSum tr2 = new TwoSum(tr1.estimate, a11 * a23 * a32);
        TwoSum det = new TwoSum(tl2.estimate, -tr2.estimate);
        return det.estimate + det.error + tl1.error + tl2.error - tr1.error - tr2.error;
    }

    public static Orientation orientation(Position p0, Position p1, Position p2) {
        double det = NumericalMethods.deltaDeterminant(p0, p1, p2);
        if (det == 0.0) {
            return Orientation.Colinear;
        }
        return det > 0.0 ? Orientation.Counterclockwise : Orientation.Clockwise;
    }

    public static double area(LinearRing<?> ring) {
        return IntStream.range(1, ring.getPositions().size()).parallel().boxed().map(idx -> NumericalMethods.shoelaceStep(idx, ring.getPositions())).reduce((a, b) -> a + b).filter(orientation -> orientation != 0.0).orElseThrow(() -> new IllegalArgumentException("Ring is collinear in 2D"));
    }

    private static double shoelaceStep(Integer idx, PositionSequence<?> positions) {
        return NumericalMethods.determinant(positions.getPositionN(idx - 1), positions.getPositionN(idx));
    }

    public static boolean isCounterClockwise(LinearRing<?> ring) {
        double res = NumericalMethods.orient2d(ring);
        if (res == 0.0) {
            throw new IllegalArgumentException("Positions are collinear in 2D");
        }
        return res > 0.0;
    }

    public static double orient2d(LinearRing<?> ring) {
        return NumericalMethods.orient2d(ring.getPositions());
    }

    private static double orient2d(PositionSequence<?> positions) {
        double d = 0.0;
        for (int i = 0; i < positions.size() - 1; ++i) {
            double[] p1 = ((Position)positions.getPositionN(i)).toArray(null);
            double[] p2 = ((Position)positions.getPositionN(i + 1)).toArray(null);
            d += (p1[0] - p2[0]) * (p1[1] + p2[1]);
        }
        return Math.signum(d);
    }

    public static boolean collinear(Position p0, Position p1, Position p2) {
        double det = NumericalMethods.deltaDeterminant(p0, p1, p2);
        return det == 0.0;
    }

    public static double determinant(Position p0, Position p1) {
        double[] c0 = p0.toArray(null);
        double[] c1 = p1.toArray(null);
        return NumericalMethods.determinant(c0[0], c0[1], c1[0], c1[1]);
    }

    private static double deltaDeterminant(Position p0, Position p1, Position p2) {
        double[] c0 = p0.toArray(null);
        double[] c1 = p1.toArray(null);
        double[] c2 = p2.toArray(null);
        return NumericalMethods.determinant(1.0, 1.0, 1.0, c0[0], c1[0], c2[0], c0[1], c1[1], c2[1]);
    }

    public static class TwoSum {
        final double estimate;
        final double error;

        public TwoSum(double a, double b) {
            double s = a + b;
            double a1 = s - b;
            double b1 = s - a1;
            double deltaA = a - a1;
            double deltaB = b - b1;
            this.estimate = s;
            this.error = deltaA + deltaB;
        }
    }

    public static enum Orientation {
        Clockwise,
        Counterclockwise,
        Colinear;

    }
}

