/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.reflect.Modifier;
import org.dizitart.no2.Constants;
import org.dizitart.no2.Document;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.StringUtils;

public final class ValidationUtils {
    public static void notEmpty(String value, ErrorMessage message) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new ValidationException(message);
        }
    }

    public static void notEmpty(CharSequence value, ErrorMessage message) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new ValidationException(message);
        }
    }

    public static void notNull(Object value, ErrorMessage message) {
        if (value == null) {
            throw new ValidationException(message);
        }
    }

    public static void notEmpty(Object[] array, ErrorMessage message) {
        if (array == null) {
            throw new ValidationException(message);
        }
        if (array.length == 0) {
            throw new ValidationException(message);
        }
    }

    public static void validateCollectionName(String name) {
        ValidationUtils.notNull(name, ErrorMessage.errorMessage("name can not be null", 1016));
        ValidationUtils.notEmpty(name, ErrorMessage.errorMessage("name can not be empty", 1017));
        for (String reservedName : Constants.RESERVED_NAMES) {
            if (!name.contains(reservedName)) continue;
            throw new ValidationException(ErrorMessage.errorMessage("name can not contains " + reservedName, 1018));
        }
    }

    public static boolean isValidCollectionName(String name) {
        if (StringUtils.isNullOrEmpty(name)) {
            return false;
        }
        for (String reservedName : Constants.RESERVED_NAMES) {
            if (!name.contains(reservedName)) continue;
            return false;
        }
        return true;
    }

    public static void validateLimit(FindOptions findOptions, long totalSize) {
        if (findOptions.getSize() < 0) {
            throw new ValidationException(ErrorMessage.PAGINATION_SIZE_CAN_NOT_BE_NEGATIVE);
        }
        if (findOptions.getOffset() < 0) {
            throw new ValidationException(ErrorMessage.PAGINATION_OFFSET_CAN_NOT_BE_NEGATIVE);
        }
        if (totalSize < (long)findOptions.getOffset()) {
            throw new ValidationException(ErrorMessage.PAGINATION_OFFSET_GREATER_THAN_SIZE);
        }
    }

    public static void validateDocumentIndexField(Object fieldValue, String field) {
        if (fieldValue instanceof Document) {
            throw new InvalidOperationException(ErrorMessage.errorMessage("compound index on field " + field + " is not supported", 3007));
        }
        if (fieldValue instanceof Iterable || fieldValue.getClass().isArray()) {
            throw new IndexingException(ErrorMessage.errorMessage("indexing on arrays or collections are not supported for field " + field, 5014));
        }
        if (!(fieldValue instanceof Comparable)) {
            throw new IndexingException(ErrorMessage.errorMessage("can not index on non comparable field " + field, 5015));
        }
    }

    public static void validateSearchTerm(NitriteMapper nitriteMapper, String field, Object value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1019));
        ValidationUtils.notEmpty(field, ErrorMessage.errorMessage("field can not be empty", 1020));
        if (value != null && !nitriteMapper.isValueType(value) && !(value instanceof Comparable)) {
            throw new ValidationException(ErrorMessage.errorMessage("search term is not comparable " + value, 4041));
        }
    }

    public static void validateInFilterValue(String field, Object[] values) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1021));
        ValidationUtils.notEmpty(field, ErrorMessage.errorMessage("field can not be empty", 1022));
        ValidationUtils.notNull(values, ErrorMessage.errorMessage("values can not be null", 1023));
        if (values.length == 0) {
            throw new ValidationException(ErrorMessage.errorMessage("values can not be empty", 1024));
        }
    }

    static void validateObjectIndexField(NitriteMapper nitriteMapper, Class<?> fieldType, String field) {
        Document document;
        if (!Comparable.class.isAssignableFrom(fieldType) && !fieldType.isPrimitive()) {
            throw new IndexingException(ErrorMessage.errorMessage("can not index on non comparable field " + field, 5017));
        }
        if (Iterable.class.isAssignableFrom(fieldType) || fieldType.isArray()) {
            throw new IndexingException(ErrorMessage.errorMessage("indexing on arrays or collections for field " + field + " are not supported", 5016));
        }
        if (fieldType.isPrimitive() || fieldType == NitriteId.class || fieldType.isInterface() || Modifier.isAbstract(fieldType.getModifiers())) {
            return;
        }
        try {
            document = DocumentUtils.dummyDocument(nitriteMapper, fieldType);
        }
        catch (Throwable e) {
            throw new IndexingException(ErrorMessage.errorMessage("invalid type specified " + fieldType.getName() + " for indexing", 5020), e);
        }
        if (document == null || document.size() > 0) {
            throw new InvalidOperationException(ErrorMessage.errorMessage("compound index on field " + field + " is not supported", 3006));
        }
    }

    private ValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

