/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.dizitart.no2.Document;
import org.dizitart.no2.KeyValuePair;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.Iterables;

class ProjectedDocumentIterable
implements RecordIterable<Document> {
    private final Collection<NitriteId> resultSet;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private Document projection;
    private boolean hasMore;
    private int totalCount;

    ProjectedDocumentIterable(Document projection, FindResult findResult) {
        this.projection = projection;
        this.resultSet = findResult.getIdSet() != null ? findResult.getIdSet() : new TreeSet<NitriteId>();
        this.underlyingMap = findResult.getUnderlyingMap();
        this.hasMore = findResult.isHasMore();
        this.totalCount = findResult.getTotalCount();
    }

    @Override
    public Iterator<Document> iterator() {
        return new ProjectedDocumentIterator();
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    @Override
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public Document firstOrDefault() {
        return Iterables.firstOrDefault(this);
    }

    @Override
    public List<Document> toList() {
        return Iterables.toList(this);
    }

    public String toString() {
        return this.toList().toString();
    }

    private class ProjectedDocumentIterator
    implements Iterator<Document> {
        private Iterator<NitriteId> iterator;
        private Document nextElement = null;

        ProjectedDocumentIterator() {
            this.iterator = ProjectedDocumentIterable.this.resultSet.iterator();
            this.nextMatch();
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public Document next() {
            Document returnValue = this.nextElement;
            this.nextMatch();
            return returnValue;
        }

        private void nextMatch() {
            while (this.iterator.hasNext()) {
                NitriteId next = this.iterator.next();
                Document document = (Document)ProjectedDocumentIterable.this.underlyingMap.get(next);
                if (document != null) {
                    Document projected = this.project(new Document(document));
                    if (projected == null) continue;
                    this.nextElement = projected;
                    return;
                }
                this.nextElement = null;
            }
            this.nextElement = null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.REMOVE_ON_DOCUMENT_ITERATOR_NOT_SUPPORTED);
        }

        private Document project(Document original) {
            if (ProjectedDocumentIterable.this.projection == null) {
                return original;
            }
            Document result = new Document(original);
            for (KeyValuePair keyValuePair : original) {
                if (ProjectedDocumentIterable.this.projection.containsKey(keyValuePair.getKey())) continue;
                result.remove(keyValuePair.getKey());
            }
            return result;
        }
    }
}

