/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Lookup;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.EqualsUtils;
import org.dizitart.no2.util.Iterables;

class JoinedDocumentIterable
implements RecordIterable<Document> {
    private final Collection<NitriteId> resultSet;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private boolean hasMore;
    private int totalCount;
    private Cursor foreignCursor;
    private Lookup lookup;

    JoinedDocumentIterable(FindResult findResult, Cursor foreignCursor, Lookup lookup) {
        this.foreignCursor = foreignCursor;
        this.lookup = lookup;
        this.resultSet = findResult.getIdSet() != null ? findResult.getIdSet() : new TreeSet<NitriteId>();
        this.underlyingMap = findResult.getUnderlyingMap();
        this.hasMore = findResult.isHasMore();
        this.totalCount = findResult.getTotalCount();
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    @Override
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public Document firstOrDefault() {
        return Iterables.firstOrDefault(this);
    }

    @Override
    public List<Document> toList() {
        return Iterables.toList(this);
    }

    @Override
    public Iterator<Document> iterator() {
        return new JoinedDocumentIterator();
    }

    public String toString() {
        return this.toList().toString();
    }

    private class JoinedDocumentIterator
    implements Iterator<Document> {
        private Iterator<NitriteId> iterator;

        JoinedDocumentIterator() {
            this.iterator = JoinedDocumentIterable.this.resultSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Document next() {
            NitriteId next = this.iterator.next();
            Document document = (Document)JoinedDocumentIterable.this.underlyingMap.get(next);
            if (document != null) {
                return this.join(new Document(document), JoinedDocumentIterable.this.foreignCursor, JoinedDocumentIterable.this.lookup);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException(ErrorMessage.REMOVE_ON_DOCUMENT_ITERATOR_NOT_SUPPORTED);
        }

        private Document join(Document localDocument, Cursor foreignCursor, Lookup lookup) {
            Object localObject = localDocument.get(lookup.getLocalField());
            if (localObject == null) {
                return localDocument;
            }
            Document resultDocument = new Document(localDocument);
            HashSet<Document> target = new HashSet<Document>();
            for (Document foreignDocument : foreignCursor) {
                Object foreignObject = foreignDocument.get(lookup.getForeignField());
                if (foreignObject == null || !EqualsUtils.deepEquals(foreignObject, localObject)) continue;
                target.add(foreignDocument);
            }
            if (!target.isEmpty()) {
                resultDocument.put(lookup.getTargetField(), (Object)target);
            }
            return resultDocument;
        }
    }
}

