/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collection;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.Index;
import org.dizitart.no2.IndexOptions;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RemoveOptions;
import org.dizitart.no2.UpdateOptions;
import org.dizitart.no2.WriteResult;
import org.dizitart.no2.event.ChangeInfo;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.event.ChangeType;
import org.dizitart.no2.event.EventBus;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.internals.ChangeEventBus;
import org.dizitart.no2.internals.NitriteService;
import org.dizitart.no2.meta.Attributes;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.ValidationUtils;

class DefaultNitriteCollection
implements NitriteCollection {
    private NitriteMap<NitriteId, Document> nitriteMap;
    private NitriteStore nitriteStore;
    private NitriteService nitriteService;
    private volatile boolean isDropped;
    private EventBus<ChangeInfo, ChangeListener> eventBus;
    private String collectionName;
    private NitriteContext nitriteContext;

    DefaultNitriteCollection(NitriteMap<NitriteId, Document> nitriteMap, NitriteContext nitriteContext) {
        this.nitriteMap = nitriteMap;
        this.nitriteStore = nitriteMap.getStore();
        this.nitriteContext = nitriteContext;
        this.eventBus = new ChangeEventBus(nitriteContext);
        this.nitriteService = new NitriteService(nitriteMap, nitriteContext, this.eventBus);
        this.isDropped = false;
        this.collectionName = nitriteMap.getName();
    }

    @Override
    public void createIndex(String field, IndexOptions indexOptions) {
        this.checkOpened();
        try {
            if (indexOptions == null) {
                this.nitriteService.createIndex(field, IndexType.Unique, false);
            } else {
                this.nitriteService.createIndex(field, indexOptions.getIndexType(), indexOptions.isAsync());
            }
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
        }
    }

    @Override
    public void rebuildIndex(String field, boolean async) {
        this.checkOpened();
        try {
            Index index = this.nitriteService.findIndex(field);
            if (index == null) {
                throw new IndexingException(ErrorMessage.errorMessage(field + " is not indexed", 5002));
            }
            this.validateRebuildIndex(index);
            this.nitriteService.rebuildIndex(index, async);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
        }
    }

    @Override
    public Collection<Index> listIndices() {
        this.checkOpened();
        try {
            return this.nitriteService.listIndexes();
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public boolean hasIndex(String field) {
        this.checkOpened();
        try {
            return this.nitriteService.hasIndex(field);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return false;
        }
    }

    @Override
    public boolean isIndexing(String field) {
        this.checkOpened();
        try {
            return this.nitriteService.isIndexing(field);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return false;
        }
    }

    @Override
    public void dropIndex(String field) {
        this.checkOpened();
        try {
            this.nitriteService.dropIndex(field);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
        }
    }

    @Override
    public void dropAllIndices() {
        this.checkOpened();
        try {
            this.nitriteService.dropAllIndices();
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
        }
    }

    @Override
    public WriteResult insert(Document document, Document ... documents) {
        this.checkOpened();
        try {
            return this.nitriteService.insert(document, documents);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    public WriteResult insert(Document[] documents) {
        this.checkOpened();
        try {
            return this.nitriteService.insert(documents);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public Cursor find(Filter filter) {
        this.checkOpened();
        try {
            return this.nitriteService.find(filter);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public Cursor find(FindOptions findOptions) {
        this.checkOpened();
        try {
            return this.nitriteService.find(findOptions);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public Cursor find(Filter filter, FindOptions findOptions) {
        this.checkOpened();
        try {
            return this.nitriteService.find(filter, findOptions);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public Cursor find() {
        this.checkOpened();
        try {
            return this.nitriteService.find();
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public Document getById(NitriteId nitriteId) {
        this.checkOpened();
        try {
            return this.nitriteService.getById(nitriteId);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public void drop() {
        this.checkOpened();
        try {
            this.nitriteService.dropCollection();
            this.isDropped = true;
            this.closeCollection();
            this.eventBus.post(new ChangeInfo(ChangeType.DROP));
            this.closeEventBus();
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
        }
    }

    @Override
    public boolean isDropped() {
        return this.isDropped;
    }

    @Override
    public boolean isClosed() {
        if (this.nitriteStore == null || this.nitriteStore.isClosed() || this.isDropped) {
            this.closeCollection();
            this.closeEventBus();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.closeCollection();
        this.eventBus.post(new ChangeInfo(ChangeType.CLOSE));
        this.closeEventBus();
    }

    @Override
    public String getName() {
        return this.collectionName;
    }

    @Override
    public long size() {
        this.checkOpened();
        try {
            return this.nitriteMap.sizeAsLong();
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return 0L;
        }
    }

    @Override
    public WriteResult update(Document document) {
        this.checkOpened();
        try {
            if (document.containsKey("_id")) {
                return this.update(DocumentUtils.createUniqueFilter(document), document);
            }
            throw new NotIdentifiableException(ErrorMessage.UPDATE_FAILED_AS_NO_ID_FOUND);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public WriteResult update(Document document, boolean upsert) {
        this.checkOpened();
        try {
            return this.update(DocumentUtils.createUniqueFilter(document), document, UpdateOptions.updateOptions(upsert));
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public WriteResult update(Filter filter, Document update) {
        this.checkOpened();
        try {
            return this.update(filter, update, new UpdateOptions());
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public WriteResult update(Filter filter, Document update, UpdateOptions updateOptions) {
        this.checkOpened();
        try {
            return this.nitriteService.update(filter, update, updateOptions);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public WriteResult remove(Document document) {
        this.checkOpened();
        try {
            ValidationUtils.notNull(document, ErrorMessage.errorMessage("document can not be null", 1067));
            if (document.containsKey("_id")) {
                return this.remove(DocumentUtils.createUniqueFilter(document));
            }
            throw new NotIdentifiableException(ErrorMessage.REMOVE_FAILED_AS_NO_ID_FOUND);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public WriteResult remove(Filter filter) {
        this.checkOpened();
        try {
            return this.remove(filter, new RemoveOptions());
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public WriteResult remove(Filter filter, RemoveOptions removeOptions) {
        this.checkOpened();
        try {
            return this.nitriteService.remove(filter, removeOptions);
        }
        catch (VirtualMachineError vme) {
            this.handleVirtualMachineError(vme);
            return null;
        }
    }

    @Override
    public void register(ChangeListener listener) {
        if (this.eventBus == null && !this.isClosed() && !this.isDropped()) {
            this.eventBus = new ChangeEventBus(this.nitriteContext);
        }
        this.eventBus.register(listener);
    }

    @Override
    public void deregister(ChangeListener listener) {
        if (this.eventBus != null) {
            this.eventBus.deregister(listener);
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.nitriteMap != null ? this.nitriteMap.getAttributes() : null;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.nitriteMap.setAttributes(attributes);
    }

    private void checkOpened() {
        if (this.nitriteStore == null || this.nitriteStore.isClosed()) {
            throw new NitriteIOException(ErrorMessage.STORE_IS_CLOSED);
        }
        if (this.isDropped) {
            throw new NitriteIOException(ErrorMessage.COLLECTION_IS_DROPPED);
        }
    }

    private void validateRebuildIndex(Index index) {
        ValidationUtils.notNull(index, ErrorMessage.errorMessage("index can not be null", 1072));
        if (!this.hasIndex(index.getField())) {
            throw new IndexingException(ErrorMessage.errorMessage(index + " does not exists for collection " + this.nitriteMap.getName(), 5021));
        }
        if (this.isIndexing(index.getField())) {
            throw new IndexingException(ErrorMessage.errorMessage("indexing on value " + index.getField() + " is currently running", 5003));
        }
    }

    private void handleVirtualMachineError(VirtualMachineError vme) {
        if (this.nitriteStore != null) {
            this.nitriteStore.closeImmediately();
            this.close();
        }
        if (vme != null) {
            throw vme;
        }
    }

    private void closeCollection() {
        this.nitriteStore = null;
        this.nitriteMap = null;
        this.nitriteService = null;
    }

    private void closeEventBus() {
        if (this.eventBus != null) {
            this.eventBus.close();
        }
        this.eventBus = null;
    }
}

