/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import org.dizitart.no2.Filter;
import org.dizitart.no2.filters.AndFilter;
import org.dizitart.no2.filters.ElementMatchFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.GreaterEqualFilter;
import org.dizitart.no2.filters.GreaterThanFilter;
import org.dizitart.no2.filters.InFilter;
import org.dizitart.no2.filters.LesserEqualFilter;
import org.dizitart.no2.filters.LesserThanFilter;
import org.dizitart.no2.filters.NotFilter;
import org.dizitart.no2.filters.OrFilter;
import org.dizitart.no2.filters.RegexFilter;
import org.dizitart.no2.filters.TextFilter;

public final class Filters {
    public static final Filter ALL = null;

    public static Filter eq(String field, Object value) {
        return new EqualsFilter(field, value);
    }

    public static Filter and(Filter ... filters) {
        return new AndFilter(filters);
    }

    public static Filter or(Filter ... filters) {
        return new OrFilter(filters);
    }

    public static Filter not(Filter filter) {
        return new NotFilter(filter);
    }

    public static Filter gt(String field, Object value) {
        return new GreaterThanFilter(field, value);
    }

    public static Filter gte(String field, Object value) {
        return new GreaterEqualFilter(field, value);
    }

    public static Filter lt(String field, Object value) {
        return new LesserThanFilter(field, value);
    }

    public static Filter lte(String field, Object value) {
        return new LesserEqualFilter(field, value);
    }

    public static Filter text(String field, String value) {
        return new TextFilter(field, value);
    }

    public static Filter regex(String field, String value) {
        return new RegexFilter(field, value);
    }

    public static Filter in(String field, Object ... values) {
        return new InFilter(field, values);
    }

    public static Filter elemMatch(String field, Filter filter) {
        return new ElementMatchFilter(field, filter);
    }

    private Filters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

