/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.dizitart.no2.mvstore.compat.v1.mvstore.Chunk;
import org.dizitart.no2.mvstore.compat.v1.mvstore.CursorPos;
import org.dizitart.no2.mvstore.compat.v1.mvstore.DataUtils;
import org.dizitart.no2.mvstore.compat.v1.mvstore.MVMap;
import org.dizitart.no2.mvstore.compat.v1.mvstore.MVStore;
import org.dizitart.no2.mvstore.compat.v1.mvstore.WriteBuffer;
import org.dizitart.no2.mvstore.compat.v1.mvstore.compress.Compressor;
import org.dizitart.no2.mvstore.compat.v1.mvstore.type.DataType;
import org.h2.util.Utils;

public abstract class Page
implements Cloneable {
    public final MVMap<?, ?> map;
    private volatile long pos;
    private int cachedCompare;
    private int memory;
    private int diskSpaceUsed;
    private Object[] keys;
    private static final AtomicLongFieldUpdater<Page> posUpdater = AtomicLongFieldUpdater.newUpdater(Page.class, "pos");
    static final int PAGE_MEMORY_CHILD = 24;
    private static final int PAGE_MEMORY = 81;
    static final int PAGE_NODE_MEMORY = 121;
    static final int PAGE_LEAF_MEMORY = 113;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int IN_MEMORY = Integer.MIN_VALUE;
    private static final PageReference[] SINGLE_EMPTY = new PageReference[]{PageReference.EMPTY};

    Page(MVMap<?, ?> map) {
        this.map = map;
    }

    Page(MVMap<?, ?> map, Page source) {
        this(map, source.keys);
        this.memory = source.memory;
    }

    Page(MVMap<?, ?> map, Object[] keys) {
        this.map = map;
        this.keys = keys;
    }

    static Page createEmptyLeaf(MVMap<?, ?> map) {
        return Page.createLeaf(map, EMPTY_OBJECT_ARRAY, EMPTY_OBJECT_ARRAY, 113);
    }

    static Page createEmptyNode(MVMap<?, ?> map) {
        return Page.createNode(map, EMPTY_OBJECT_ARRAY, SINGLE_EMPTY, 0L, 153);
    }

    public static Page createNode(MVMap<?, ?> map, Object[] keys, PageReference[] children, long totalCount, int memory) {
        assert (keys != null);
        NonLeaf page = new NonLeaf(map, keys, children, totalCount);
        page.initMemoryAccount(memory);
        return page;
    }

    static Page createLeaf(MVMap<?, ?> map, Object[] keys, Object[] values, int memory) {
        assert (keys != null);
        Leaf page = new Leaf(map, keys, values);
        page.initMemoryAccount(memory);
        return page;
    }

    private void initMemoryAccount(int memoryCount) {
        if (!this.map.isPersistent()) {
            this.memory = Integer.MIN_VALUE;
        } else if (memoryCount == 0) {
            this.recalculateMemory();
        } else {
            this.addMemory(memoryCount);
            assert (memoryCount == this.getMemory());
        }
    }

    static Object get(Page p, Object key) {
        while (true) {
            int index = p.binarySearch(key);
            if (p.isLeaf()) {
                return index >= 0 ? p.getValue(index) : null;
            }
            if (index++ < 0) {
                index = -index;
            }
            p = p.getChildPage(index);
        }
    }

    static Page read(ByteBuffer buff, long pos, MVMap<?, ?> map) {
        boolean leaf = (DataUtils.getPageType(pos) & 1) == 0;
        Page p = leaf ? new Leaf(map) : new NonLeaf(map);
        p.pos = pos;
        int chunkId = DataUtils.getPageChunkId(pos);
        p.read(buff, chunkId);
        return p;
    }

    public final int getMapId() {
        return this.map.getId();
    }

    abstract Page copy(MVMap<?, ?> var1);

    public Object getKey(int index) {
        return this.keys[index];
    }

    public abstract Page getChildPage(int var1);

    public abstract long getChildPagePos(int var1);

    public abstract Object getValue(int var1);

    public final int getKeyCount() {
        return this.keys.length;
    }

    public final boolean isLeaf() {
        return this.getNodeType() == 0;
    }

    public abstract int getNodeType();

    public final long getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.dump(buff);
        return buff.toString();
    }

    protected void dump(StringBuilder buff) {
        buff.append("id: ").append(System.identityHashCode(this)).append('\n');
        buff.append("pos: ").append(Long.toHexString(this.pos)).append('\n');
        if (this.isSaved()) {
            int chunkId = DataUtils.getPageChunkId(this.pos);
            buff.append("chunk: ").append(Long.toHexString(chunkId)).append('\n');
        }
    }

    public final Page copy() {
        Page newPage = this.clone();
        newPage.pos = 0L;
        return newPage;
    }

    protected final Page clone() {
        Page clone;
        try {
            clone = (Page)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new RuntimeException(impossible);
        }
        return clone;
    }

    int binarySearch(Object key) {
        int low = 0;
        int high = this.getKeyCount() - 1;
        int x = this.cachedCompare - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        Object[] k = this.keys;
        while (low <= high) {
            int compare = this.map.compare(key, k[x]);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                this.cachedCompare = x + 1;
                return x;
            }
            x = low + high >>> 1;
        }
        this.cachedCompare = low;
        return -(low + 1);
    }

    abstract Page split(int var1);

    final Object[] splitKeys(int aCount, int bCount) {
        assert (aCount + bCount <= this.getKeyCount());
        Object[] aKeys = this.createKeyStorage(aCount);
        Object[] bKeys = this.createKeyStorage(bCount);
        System.arraycopy(this.keys, 0, aKeys, 0, aCount);
        System.arraycopy(this.keys, this.getKeyCount() - bCount, bKeys, 0, bCount);
        this.keys = aKeys;
        return bKeys;
    }

    abstract void expand(int var1, Object[] var2, Object[] var3);

    final void expandKeys(int extraKeyCount, Object[] extraKeys) {
        int keyCount = this.getKeyCount();
        Object[] newKeys = this.createKeyStorage(keyCount + extraKeyCount);
        System.arraycopy(this.keys, 0, newKeys, 0, keyCount);
        System.arraycopy(extraKeys, 0, newKeys, keyCount, extraKeyCount);
        this.keys = newKeys;
    }

    public abstract long getTotalCount();

    abstract long getCounts(int var1);

    public abstract void setChild(int var1, Page var2);

    public final void setKey(int index, Object key) {
        this.keys = (Object[])this.keys.clone();
        if (this.isPersistent()) {
            Object old = this.keys[index];
            DataType keyType = this.map.getKeyType();
            int mem = keyType.getMemory(key);
            if (old != null) {
                mem -= keyType.getMemory(old);
            }
            this.addMemory(mem);
        }
        this.keys[index] = key;
    }

    public abstract Object setValue(int var1, Object var2);

    public abstract void insertLeaf(int var1, Object var2, Object var3);

    public abstract void insertNode(int var1, Object var2, Page var3);

    final void insertKey(int index, Object key) {
        int keyCount = this.getKeyCount();
        assert (index <= keyCount) : index + " > " + keyCount;
        Object[] newKeys = this.createKeyStorage(keyCount + 1);
        DataUtils.copyWithGap(this.keys, newKeys, keyCount, index);
        this.keys = newKeys;
        this.keys[index] = key;
        if (this.isPersistent()) {
            this.addMemory(8 + this.map.getKeyType().getMemory(key));
        }
    }

    public void remove(int index) {
        int keyCount = this.getKeyCount();
        DataType keyType = this.map.getKeyType();
        if (index == keyCount) {
            --index;
        }
        if (this.isPersistent()) {
            Object old = this.getKey(index);
            this.addMemory(-8 - keyType.getMemory(old));
        }
        Object[] newKeys = this.createKeyStorage(keyCount - 1);
        DataUtils.copyExcept(this.keys, newKeys, keyCount, index);
        this.keys = newKeys;
    }

    private void read(ByteBuffer buff, int chunkId) {
        boolean compressed;
        int pageLength = buff.remaining() + 10;
        int len = DataUtils.readVarInt(buff);
        this.keys = this.createKeyStorage(len);
        byte type = buff.get();
        if (this.isLeaf() != ((type & 1) == 0)) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected node type {1}, got {2}", chunkId, this.isLeaf() ? "0" : "1", type);
        }
        if (!this.isLeaf()) {
            this.readPayLoad(buff);
        }
        boolean bl = compressed = (type & 2) != 0;
        if (compressed) {
            Compressor compressor = (type & 6) == 6 ? this.map.getStore().getCompressorHigh() : this.map.getStore().getCompressorFast();
            int lenAdd = DataUtils.readVarInt(buff);
            int compLen = buff.remaining();
            byte[] comp = Utils.newBytes((int)compLen);
            buff.get(comp);
            int l = compLen + lenAdd;
            buff = ByteBuffer.allocate(l);
            compressor.expand(comp, 0, compLen, buff.array(), buff.arrayOffset(), l);
        }
        this.map.getKeyType().read(buff, this.keys, len, true);
        if (this.isLeaf()) {
            this.readPayLoad(buff);
        }
        this.diskSpaceUsed = pageLength;
        this.recalculateMemory();
    }

    protected abstract void readPayLoad(ByteBuffer var1);

    public final boolean isSaved() {
        return DataUtils.isPageSaved(this.pos);
    }

    public final boolean isRemoved() {
        return DataUtils.isPageRemoved(this.pos);
    }

    private boolean markAsRemoved() {
        assert (this.getTotalCount() > 0L) : this;
        do {
            long pagePos;
            if (DataUtils.isPageSaved(pagePos = this.pos)) {
                return false;
            }
            assert (!DataUtils.isPageRemoved(pagePos));
        } while (!posUpdater.compareAndSet(this, 0L, 1L));
        return true;
    }

    protected final int write(Chunk chunk, WriteBuffer buff) {
        int compressionLevel;
        int start = buff.position();
        int len = this.getKeyCount();
        int type = this.isLeaf() ? 0 : 1;
        buff.putInt(0).putShort((short)0).putVarInt(this.map.getId()).putVarInt(len);
        int typePos = buff.position();
        buff.put((byte)type);
        this.writeChildren(buff, true);
        int compressStart = buff.position();
        this.map.getKeyType().write(buff, this.keys, len, true);
        this.writeValues(buff);
        MVStore store = this.map.getStore();
        int expLen = buff.position() - compressStart;
        if (expLen > 16 && (compressionLevel = store.getCompressionLevel()) > 0) {
            int compressType;
            Compressor compressor;
            if (compressionLevel == 1) {
                compressor = this.map.getStore().getCompressorFast();
                compressType = 2;
            } else {
                compressor = this.map.getStore().getCompressorHigh();
                compressType = 6;
            }
            byte[] exp = new byte[expLen];
            buff.position(compressStart).get(exp);
            byte[] comp = new byte[expLen * 2];
            int compLen = compressor.compress(exp, expLen, comp, 0);
            int plus = DataUtils.getVarIntLen(compLen - expLen);
            if (compLen + plus < expLen) {
                buff.position(typePos).put((byte)(type + compressType));
                buff.position(compressStart).putVarInt(expLen - compLen).put(comp, 0, compLen);
            }
        }
        int pageLength = buff.position() - start;
        int chunkId = chunk.id;
        int check = DataUtils.getCheckValue(chunkId) ^ DataUtils.getCheckValue(start) ^ DataUtils.getCheckValue(pageLength);
        buff.putInt(start, pageLength).putShort(start + 4, (short)check);
        if (this.isSaved()) {
            throw DataUtils.newIllegalStateException(3, "Page already stored", new Object[0]);
        }
        long pagePos = DataUtils.getPagePos(chunkId, start, pageLength, type);
        boolean isDeleted = this.isRemoved();
        while (!posUpdater.compareAndSet(this, isDeleted ? 1L : 0L, pagePos)) {
            isDeleted = this.isRemoved();
        }
        store.cachePage(this);
        if (type == 1) {
            store.cachePage(this);
        }
        int pageLengthEncoded = DataUtils.getPageMaxLength(this.pos);
        boolean singleWriter = this.map.isSingleWriter();
        chunk.accountForWrittenPage(pageLengthEncoded, singleWriter);
        if (isDeleted) {
            store.accountForRemovedPage(pagePos, chunk.version + 1L, singleWriter);
        }
        this.diskSpaceUsed = pageLengthEncoded != 0x200000 ? pageLengthEncoded : pageLength;
        return typePos + 1;
    }

    protected abstract void writeValues(WriteBuffer var1);

    protected abstract void writeChildren(WriteBuffer var1, boolean var2);

    abstract void writeUnsavedRecursive(Chunk var1, WriteBuffer var2);

    abstract void writeEnd();

    public abstract int getRawChildPageCount();

    public final boolean equals(Object other) {
        return other == this || other instanceof Page && this.isSaved() && ((Page)other).pos == this.pos;
    }

    public final int hashCode() {
        return this.isSaved() ? (int)(this.pos | this.pos >>> 32) : super.hashCode();
    }

    protected final boolean isPersistent() {
        return this.memory != Integer.MIN_VALUE;
    }

    public final int getMemory() {
        if (this.isPersistent()) {
            return this.memory;
        }
        return 0;
    }

    public long getDiskSpaceUsed() {
        long r = 0L;
        if (this.isPersistent()) {
            r += (long)this.diskSpaceUsed;
            if (!this.isLeaf()) {
                for (int i = 0; i < this.getRawChildPageCount(); ++i) {
                    long pos = this.getChildPagePos(i);
                    if (pos == 0L) continue;
                    r += this.getChildPage(i).getDiskSpaceUsed();
                }
            }
        }
        return r;
    }

    final void addMemory(int mem) {
        this.memory += mem;
    }

    final void recalculateMemory() {
        assert (this.isPersistent());
        this.memory = this.calculateMemory();
    }

    protected int calculateMemory() {
        int keyCount = this.getKeyCount();
        int mem = keyCount * 8;
        DataType keyType = this.map.getKeyType();
        for (int i = 0; i < keyCount; ++i) {
            mem += keyType.getMemory(this.keys[i]);
        }
        return mem;
    }

    public boolean isComplete() {
        return true;
    }

    public void setComplete() {
    }

    public final int removePage(long version) {
        if (this.isPersistent() && this.getTotalCount() > 0L) {
            MVStore store = this.map.store;
            if (!this.markAsRemoved()) {
                long pagePos = this.pos;
                store.accountForRemovedPage(pagePos, version, this.map.isSingleWriter());
            } else {
                return -this.memory;
            }
        }
        return 0;
    }

    public abstract CursorPos getPrependCursorPos(CursorPos var1);

    public abstract CursorPos getAppendCursorPos(CursorPos var1);

    public abstract int removeAllRecursive(long var1);

    private Object[] createKeyStorage(int size) {
        return new Object[size];
    }

    final Object[] createValueStorage(int size) {
        return new Object[size];
    }

    private static class Leaf
    extends Page {
        private Object[] values;

        Leaf(MVMap<?, ?> map) {
            super(map);
        }

        private Leaf(MVMap<?, ?> map, Leaf source) {
            super(map, source);
            this.values = source.values;
        }

        Leaf(MVMap<?, ?> map, Object[] keys, Object[] values) {
            super(map, keys);
            this.values = values;
        }

        @Override
        public int getNodeType() {
            return 0;
        }

        @Override
        public Page copy(MVMap<?, ?> map) {
            return new Leaf(map, this);
        }

        @Override
        public Page getChildPage(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getChildPagePos(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(int index) {
            return this.values[index];
        }

        @Override
        public Page split(int at) {
            assert (!this.isSaved());
            int b = this.getKeyCount() - at;
            Object[] bKeys = this.splitKeys(at, b);
            Object[] bValues = this.createValueStorage(b);
            if (this.values != null) {
                Object[] aValues = this.createValueStorage(at);
                System.arraycopy(this.values, 0, aValues, 0, at);
                System.arraycopy(this.values, at, bValues, 0, b);
                this.values = aValues;
            }
            Page newPage = Leaf.createLeaf(this.map, bKeys, bValues, 0);
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
            return newPage;
        }

        @Override
        public void expand(int extraKeyCount, Object[] extraKeys, Object[] extraValues) {
            int keyCount = this.getKeyCount();
            this.expandKeys(extraKeyCount, extraKeys);
            if (this.values != null) {
                Object[] newValues = this.createValueStorage(keyCount + extraKeyCount);
                System.arraycopy(this.values, 0, newValues, 0, keyCount);
                System.arraycopy(extraValues, 0, newValues, keyCount, extraKeyCount);
                this.values = newValues;
            }
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
        }

        @Override
        public long getTotalCount() {
            return this.getKeyCount();
        }

        @Override
        long getCounts(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setChild(int index, Page c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object setValue(int index, Object value) {
            DataType valueType = this.map.getValueType();
            this.values = (Object[])this.values.clone();
            Object old = this.setValueInternal(index, value);
            if (this.isPersistent()) {
                this.addMemory(valueType.getMemory(value) - valueType.getMemory(old));
            }
            return old;
        }

        private Object setValueInternal(int index, Object value) {
            Object old = this.values[index];
            this.values[index] = value;
            return old;
        }

        @Override
        public void insertLeaf(int index, Object key, Object value) {
            int keyCount = this.getKeyCount();
            this.insertKey(index, key);
            if (this.values != null) {
                Object[] newValues = this.createValueStorage(keyCount + 1);
                DataUtils.copyWithGap(this.values, newValues, keyCount, index);
                this.values = newValues;
                this.setValueInternal(index, value);
                if (this.isPersistent()) {
                    this.addMemory(8 + this.map.getValueType().getMemory(value));
                }
            }
        }

        @Override
        public void insertNode(int index, Object key, Page childPage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int index) {
            int keyCount = this.getKeyCount();
            super.remove(index);
            if (this.values != null) {
                if (this.isPersistent()) {
                    Object old = this.getValue(index);
                    this.addMemory(-8 - this.map.getValueType().getMemory(old));
                }
                Object[] newValues = this.createValueStorage(keyCount - 1);
                DataUtils.copyExcept(this.values, newValues, keyCount, index);
                this.values = newValues;
            }
        }

        @Override
        public int removeAllRecursive(long version) {
            return this.removePage(version);
        }

        @Override
        public CursorPos getPrependCursorPos(CursorPos cursorPos) {
            return new CursorPos(this, -1, cursorPos);
        }

        @Override
        public CursorPos getAppendCursorPos(CursorPos cursorPos) {
            int keyCount = this.getKeyCount();
            return new CursorPos(this, -keyCount - 1, cursorPos);
        }

        @Override
        protected void readPayLoad(ByteBuffer buff) {
            int keyCount = this.getKeyCount();
            this.values = this.createValueStorage(keyCount);
            this.map.getValueType().read(buff, this.values, this.getKeyCount(), false);
        }

        @Override
        protected void writeValues(WriteBuffer buff) {
            this.map.getValueType().write(buff, this.values, this.getKeyCount(), false);
        }

        @Override
        protected void writeChildren(WriteBuffer buff, boolean withCounts) {
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, WriteBuffer buff) {
            if (!this.isSaved()) {
                this.write(chunk, buff);
            }
        }

        @Override
        void writeEnd() {
        }

        @Override
        public int getRawChildPageCount() {
            return 0;
        }

        @Override
        protected int calculateMemory() {
            int keyCount = this.getKeyCount();
            int mem = super.calculateMemory() + 113 + keyCount * 8;
            DataType valueType = this.map.getValueType();
            for (int i = 0; i < keyCount; ++i) {
                mem += valueType.getMemory(this.values[i]);
            }
            return mem;
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            int keyCount = this.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(this.getKey(i));
                if (this.values == null) continue;
                buff.append(':');
                buff.append(this.getValue(i));
            }
        }
    }

    private static class IncompleteNonLeaf
    extends NonLeaf {
        private boolean complete;

        IncompleteNonLeaf(MVMap<?, ?> map, NonLeaf source) {
            super(map, source, IncompleteNonLeaf.constructEmptyPageRefs(source.getRawChildPageCount()), source.getTotalCount());
        }

        private static PageReference[] constructEmptyPageRefs(int size) {
            Object[] children = new PageReference[size];
            Arrays.fill(children, PageReference.EMPTY);
            return children;
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, WriteBuffer buff) {
            if (this.complete) {
                super.writeUnsavedRecursive(chunk, buff);
            } else if (!this.isSaved()) {
                this.writeChildrenRecursive(chunk, buff);
            }
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void setComplete() {
            this.recalculateTotalCount();
            this.complete = true;
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            buff.append(", complete:").append(this.complete);
        }
    }

    private static class NonLeaf
    extends Page {
        private PageReference[] children;
        private long totalCount;

        NonLeaf(MVMap<?, ?> map) {
            super(map);
        }

        NonLeaf(MVMap<?, ?> map, NonLeaf source, PageReference[] children, long totalCount) {
            super(map, source);
            this.children = children;
            this.totalCount = totalCount;
        }

        NonLeaf(MVMap<?, ?> map, Object[] keys, PageReference[] children, long totalCount) {
            super(map, keys);
            this.children = children;
            this.totalCount = totalCount;
        }

        @Override
        public int getNodeType() {
            return 1;
        }

        @Override
        public Page copy(MVMap<?, ?> map) {
            return new IncompleteNonLeaf(map, this);
        }

        @Override
        public Page getChildPage(int index) {
            PageReference ref = this.children[index];
            Page page = ref.getPage();
            if (page == null) {
                page = this.map.readPage(ref.getPos());
                assert (ref.getPos() == page.getPos());
                assert (ref.count == page.getTotalCount());
            }
            return page;
        }

        @Override
        public long getChildPagePos(int index) {
            return this.children[index].getPos();
        }

        @Override
        public Object getValue(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Page split(int at) {
            assert (!this.isSaved());
            int b = this.getKeyCount() - at;
            Object[] bKeys = this.splitKeys(at, b - 1);
            PageReference[] aChildren = new PageReference[at + 1];
            PageReference[] bChildren = new PageReference[b];
            System.arraycopy(this.children, 0, aChildren, 0, at + 1);
            System.arraycopy(this.children, at + 1, bChildren, 0, b);
            this.children = aChildren;
            long t = 0L;
            for (PageReference x : aChildren) {
                t += x.count;
            }
            this.totalCount = t;
            t = 0L;
            for (PageReference x : bChildren) {
                t += x.count;
            }
            Page newPage = NonLeaf.createNode(this.map, bKeys, bChildren, t, 0);
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
            return newPage;
        }

        @Override
        public void expand(int keyCount, Object[] extraKeys, Object[] extraValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTotalCount() {
            assert (!this.isComplete() || this.totalCount == this.calculateTotalCount()) : "Total count: " + this.totalCount + " != " + this.calculateTotalCount();
            return this.totalCount;
        }

        private long calculateTotalCount() {
            long check = 0L;
            int keyCount = this.getKeyCount();
            for (int i = 0; i <= keyCount; ++i) {
                check += this.children[i].count;
            }
            return check;
        }

        void recalculateTotalCount() {
            this.totalCount = this.calculateTotalCount();
        }

        @Override
        long getCounts(int index) {
            return this.children[index].count;
        }

        @Override
        public void setChild(int index, Page c) {
            assert (c != null);
            PageReference child = this.children[index];
            if (c != child.getPage() || c.getPos() != child.getPos()) {
                this.totalCount += c.getTotalCount() - child.count;
                this.children = (PageReference[])this.children.clone();
                this.children[index] = new PageReference(c);
            }
        }

        @Override
        public Object setValue(int index, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertLeaf(int index, Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertNode(int index, Object key, Page childPage) {
            int childCount = this.getRawChildPageCount();
            this.insertKey(index, key);
            PageReference[] newChildren = new PageReference[childCount + 1];
            DataUtils.copyWithGap(this.children, newChildren, childCount, index);
            this.children = newChildren;
            this.children[index] = new PageReference(childPage);
            this.totalCount += childPage.getTotalCount();
            if (this.isPersistent()) {
                this.addMemory(32);
            }
        }

        @Override
        public void remove(int index) {
            int childCount = this.getRawChildPageCount();
            super.remove(index);
            if (this.isPersistent()) {
                this.addMemory(-32);
            }
            this.totalCount -= this.children[index].count;
            PageReference[] newChildren = new PageReference[childCount - 1];
            DataUtils.copyExcept(this.children, newChildren, childCount, index);
            this.children = newChildren;
        }

        @Override
        public int removeAllRecursive(long version) {
            int unsavedMemory = this.removePage(version);
            if (this.isPersistent()) {
                int size = this.map.getChildPageCount(this);
                for (int i = 0; i < size; ++i) {
                    PageReference ref = this.children[i];
                    Page page = ref.getPage();
                    if (page != null) {
                        unsavedMemory += page.removeAllRecursive(version);
                        continue;
                    }
                    long pagePos = ref.getPos();
                    assert (DataUtils.isPageSaved(pagePos));
                    if (DataUtils.isLeafPosition(pagePos)) {
                        this.map.store.accountForRemovedPage(pagePos, version, this.map.isSingleWriter());
                        continue;
                    }
                    unsavedMemory += this.map.readPage(pagePos).removeAllRecursive(version);
                }
            }
            return unsavedMemory;
        }

        @Override
        public CursorPos getPrependCursorPos(CursorPos cursorPos) {
            Page childPage = this.getChildPage(0);
            return childPage.getPrependCursorPos(new CursorPos(this, 0, cursorPos));
        }

        @Override
        public CursorPos getAppendCursorPos(CursorPos cursorPos) {
            int keyCount = this.getKeyCount();
            Page childPage = this.getChildPage(keyCount);
            return childPage.getAppendCursorPos(new CursorPos(this, keyCount, cursorPos));
        }

        @Override
        protected void readPayLoad(ByteBuffer buff) {
            int keyCount = this.getKeyCount();
            this.children = new PageReference[keyCount + 1];
            long[] p = new long[keyCount + 1];
            for (int i = 0; i <= keyCount; ++i) {
                p[i] = buff.getLong();
            }
            long total = 0L;
            for (int i = 0; i <= keyCount; ++i) {
                long s = DataUtils.readVarLong(buff);
                long position = p[i];
                assert (position != 0L ? s >= 0L : s == 0L);
                total += s;
                this.children[i] = position == 0L ? PageReference.EMPTY : new PageReference(position, s);
            }
            this.totalCount = total;
        }

        @Override
        protected void writeValues(WriteBuffer buff) {
        }

        @Override
        protected void writeChildren(WriteBuffer buff, boolean withCounts) {
            int i;
            int keyCount = this.getKeyCount();
            for (i = 0; i <= keyCount; ++i) {
                buff.putLong(this.children[i].getPos());
            }
            if (withCounts) {
                for (i = 0; i <= keyCount; ++i) {
                    buff.putVarLong(this.children[i].count);
                }
            }
        }

        @Override
        void writeUnsavedRecursive(Chunk chunk, WriteBuffer buff) {
            if (!this.isSaved()) {
                int patch = this.write(chunk, buff);
                this.writeChildrenRecursive(chunk, buff);
                int old = buff.position();
                buff.position(patch);
                this.writeChildren(buff, false);
                buff.position(old);
            }
        }

        void writeChildrenRecursive(Chunk chunk, WriteBuffer buff) {
            int len = this.getRawChildPageCount();
            for (int i = 0; i < len; ++i) {
                PageReference ref = this.children[i];
                Page p = ref.getPage();
                if (p == null) continue;
                p.writeUnsavedRecursive(chunk, buff);
                ref.resetPos();
            }
        }

        @Override
        void writeEnd() {
            int len = this.getRawChildPageCount();
            for (int i = 0; i < len; ++i) {
                this.children[i].clearPageReference();
            }
        }

        @Override
        public int getRawChildPageCount() {
            return this.getKeyCount() + 1;
        }

        @Override
        protected int calculateMemory() {
            return super.calculateMemory() + 121 + this.getRawChildPageCount() * 32;
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            int keyCount = this.getKeyCount();
            for (int i = 0; i <= keyCount; ++i) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append("[").append(Long.toHexString(this.children[i].getPos())).append("]");
                if (i >= keyCount) continue;
                buff.append(" ").append(this.getKey(i));
            }
        }
    }

    public static final class PageReference {
        public static final PageReference EMPTY = new PageReference(null, 0L, 0L);
        private long pos;
        private Page page;
        final long count;

        public PageReference(Page page) {
            this(page, page.getPos(), page.getTotalCount());
        }

        PageReference(long pos, long count) {
            this(null, pos, count);
            assert (DataUtils.isPageSaved(pos));
        }

        private PageReference(Page page, long pos, long count) {
            this.page = page;
            this.pos = pos;
            this.count = count;
        }

        public Page getPage() {
            return this.page;
        }

        void clearPageReference() {
            if (this.page != null) {
                this.page.writeEnd();
                assert (this.page.isSaved() || !this.page.isComplete());
                if (this.page.isSaved()) {
                    assert (this.pos == this.page.getPos());
                    assert (this.count == this.page.getTotalCount()) : this.count + " != " + this.page.getTotalCount();
                    this.page = null;
                }
            }
        }

        long getPos() {
            return this.pos;
        }

        void resetPos() {
            Page p = this.page;
            if (p != null && p.isSaved()) {
                this.pos = p.getPos();
                assert (this.count == p.getTotalCount());
            }
        }

        public String toString() {
            return "Cnt:" + this.count + ", pos:" + (String)(this.pos == 0L ? "0" : DataUtils.getPageChunkId(this.pos) + "-" + DataUtils.getPageOffset(this.pos) + ":" + DataUtils.getPageMaxLength(this.pos)) + ((this.page == null ? DataUtils.getPageType(this.pos) == 0 : this.page.isLeaf()) ? " leaf" : " node") + ", page:{" + this.page + "}";
        }
    }
}

