/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import org.dizitart.no2.mvstore.compat.v1.mvstore.DataUtils;
import org.dizitart.no2.mvstore.compat.v1.mvstore.FileStore;
import org.dizitart.no2.mvstore.compat.v1.mvstore.WriteBuffer;

public class Chunk {
    public static final int MAX_ID = 0x3FFFFFF;
    static final int MAX_HEADER_LENGTH = 1024;
    static final int FOOTER_LENGTH = 128;
    private static final String ATTR_CHUNK = "chunk";
    private static final String ATTR_BLOCK = "block";
    private static final String ATTR_LEN = "len";
    private static final String ATTR_MAP = "map";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_NEXT = "next";
    private static final String ATTR_PAGES = "pages";
    private static final String ATTR_ROOT = "root";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_LIVE_MAX = "liveMax";
    private static final String ATTR_LIVE_PAGES = "livePages";
    private static final String ATTR_UNUSED = "unused";
    private static final String ATTR_UNUSED_AT_VERSION = "unusedAtVersion";
    private static final String ATTR_PIN_COUNT = "pinCount";
    private static final String ATTR_FLETCHER = "fletcher";
    public final int id;
    public volatile long block;
    public int len;
    int pageCount;
    int pageCountLive;
    public long maxLen;
    public long maxLenLive;
    int collectPriority;
    long metaRootPos;
    public long version;
    public long time;
    public long unused;
    long unusedAtVersion;
    public int mapId;
    public long next;
    private int pinCount;

    Chunk(int id) {
        this.id = id;
    }

    static Chunk readChunkHeader(ByteBuffer buff, long start) {
        int pos = buff.position();
        byte[] data = new byte[Math.min(buff.remaining(), 1024)];
        buff.get(data);
        try {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 10) continue;
                buff.position(pos + i + 1);
                String s = new String(data, 0, i, StandardCharsets.ISO_8859_1).trim();
                return Chunk.fromString(s);
            }
        }
        catch (Exception e) {
            throw DataUtils.newIllegalStateException(6, "File corrupt reading chunk at position {0}", start, e);
        }
        throw DataUtils.newIllegalStateException(6, "File corrupt reading chunk at position {0}", start);
    }

    void writeChunkHeader(WriteBuffer buff, int minLength) {
        long delimiterPosition = buff.position() + minLength - 1;
        buff.put(this.asString().getBytes(StandardCharsets.ISO_8859_1));
        while ((long)buff.position() < delimiterPosition) {
            buff.put((byte)32);
        }
        if (minLength != 0 && (long)buff.position() > delimiterPosition) {
            throw DataUtils.newIllegalStateException(3, "Chunk metadata too long", new Object[0]);
        }
        buff.put((byte)10);
    }

    static String getMetaKey(int chunkId) {
        return "chunk." + Integer.toHexString(chunkId);
    }

    public static Chunk fromString(String s) {
        HashMap<String, String> map = DataUtils.parseMap(s);
        int id = DataUtils.readHexInt(map, ATTR_CHUNK, 0);
        Chunk c = new Chunk(id);
        c.block = DataUtils.readHexLong(map, ATTR_BLOCK, 0L);
        c.len = DataUtils.readHexInt(map, ATTR_LEN, 0);
        c.pageCount = DataUtils.readHexInt(map, ATTR_PAGES, 0);
        c.pageCountLive = DataUtils.readHexInt(map, ATTR_LIVE_PAGES, c.pageCount);
        c.mapId = DataUtils.readHexInt(map, ATTR_MAP, 0);
        c.maxLen = DataUtils.readHexLong(map, ATTR_MAX, 0L);
        c.maxLenLive = DataUtils.readHexLong(map, ATTR_LIVE_MAX, c.maxLen);
        c.metaRootPos = DataUtils.readHexLong(map, ATTR_ROOT, 0L);
        c.time = DataUtils.readHexLong(map, ATTR_TIME, 0L);
        c.unused = DataUtils.readHexLong(map, ATTR_UNUSED, 0L);
        c.unusedAtVersion = DataUtils.readHexLong(map, ATTR_UNUSED_AT_VERSION, 0L);
        c.version = DataUtils.readHexLong(map, ATTR_VERSION, id);
        c.next = DataUtils.readHexLong(map, ATTR_NEXT, 0L);
        c.pinCount = DataUtils.readHexInt(map, ATTR_PIN_COUNT, 0);
        return c;
    }

    int getFillRate() {
        assert (this.maxLenLive <= this.maxLen) : this.maxLenLive + " > " + this.maxLen;
        if (this.maxLenLive <= 0L) {
            return 0;
        }
        if (this.maxLenLive == this.maxLen) {
            return 100;
        }
        return 1 + (int)(98L * this.maxLenLive / this.maxLen);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o instanceof Chunk && ((Chunk)o).id == this.id;
    }

    public String asString() {
        StringBuilder buff = new StringBuilder(240);
        DataUtils.appendMap(buff, ATTR_CHUNK, this.id);
        DataUtils.appendMap(buff, ATTR_BLOCK, this.block);
        DataUtils.appendMap(buff, ATTR_LEN, this.len);
        if (this.maxLen != this.maxLenLive) {
            DataUtils.appendMap(buff, ATTR_LIVE_MAX, this.maxLenLive);
        }
        if (this.pageCount != this.pageCountLive) {
            DataUtils.appendMap(buff, ATTR_LIVE_PAGES, this.pageCountLive);
        }
        DataUtils.appendMap(buff, ATTR_MAP, this.mapId);
        DataUtils.appendMap(buff, ATTR_MAX, this.maxLen);
        if (this.next != 0L) {
            DataUtils.appendMap(buff, ATTR_NEXT, this.next);
        }
        DataUtils.appendMap(buff, ATTR_PAGES, this.pageCount);
        DataUtils.appendMap(buff, ATTR_ROOT, this.metaRootPos);
        DataUtils.appendMap(buff, ATTR_TIME, this.time);
        if (this.unused != 0L) {
            DataUtils.appendMap(buff, ATTR_UNUSED, this.unused);
        }
        if (this.unusedAtVersion != 0L) {
            DataUtils.appendMap(buff, ATTR_UNUSED_AT_VERSION, this.unusedAtVersion);
        }
        DataUtils.appendMap(buff, ATTR_VERSION, this.version);
        DataUtils.appendMap(buff, ATTR_PIN_COUNT, this.pinCount);
        return buff.toString();
    }

    byte[] getFooterBytes() {
        StringBuilder buff = new StringBuilder(128);
        DataUtils.appendMap(buff, ATTR_CHUNK, this.id);
        DataUtils.appendMap(buff, ATTR_BLOCK, this.block);
        DataUtils.appendMap(buff, ATTR_VERSION, this.version);
        byte[] bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        int checksum = DataUtils.getFletcher32(bytes, 0, bytes.length);
        DataUtils.appendMap(buff, ATTR_FLETCHER, checksum);
        while (buff.length() < 127) {
            buff.append(' ');
        }
        buff.append('\n');
        return buff.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    boolean isSaved() {
        return this.block != Long.MAX_VALUE;
    }

    boolean isLive() {
        return this.pageCountLive > 0;
    }

    boolean isRewritable() {
        return this.isSaved() && this.isLive() && this.pageCountLive < this.pageCount && this.isEvacuatable();
    }

    private boolean isEvacuatable() {
        return this.pinCount == 0;
    }

    /*
     * Unable to fully structure code
     */
    ByteBuffer readBufferForPage(FileStore fileStore, long pos, int expectedMapId) {
        if (!Chunk.$assertionsDisabled && !this.isSaved()) {
            throw new AssertionError(this);
        }
        while (true) lbl-1000:
        // 3 sources

        {
            originalBlock = this.block;
            try {
                filePos = originalBlock * 4096L;
                maxPos = filePos + (long)(this.len * 4096);
                if ((filePos += (long)DataUtils.getPageOffset(pos)) < 0L) {
                    throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", new Object[]{filePos, pos, this.toString()});
                }
                length = DataUtils.getPageMaxLength(pos);
                if (length == 0x200000) {
                    length = fileStore.readFully(filePos, 128).getInt();
                }
                if ((length = (int)Math.min(maxPos - filePos, (long)length)) < 0) {
                    throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", new Object[]{length, filePos, maxPos});
                }
                buff = fileStore.readFully(filePos, length);
                offset = DataUtils.getPageOffset(pos);
                start = buff.position();
                remaining = buff.remaining();
                pageLength = buff.getInt();
                if (pageLength > remaining || pageLength < 4) {
                    throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", new Object[]{this.id, remaining, pageLength});
                }
                buff.limit(start + pageLength);
                check = buff.getShort();
                checkTest = DataUtils.getCheckValue(this.id) ^ DataUtils.getCheckValue(offset) ^ DataUtils.getCheckValue(pageLength);
                if (check != (short)checkTest) {
                    throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", new Object[]{this.id, checkTest, check});
                }
                mapId = DataUtils.readVarInt(buff);
                if (mapId != expectedMapId) {
                    throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", new Object[]{this.id, expectedMapId, mapId});
                }
                if (originalBlock != this.block) ** GOTO lbl-1000
                return buff;
            }
            catch (IllegalStateException ex) {
                if (originalBlock != this.block) continue;
                throw ex;
            }
            break;
        }
    }

    void accountForWrittenPage(int pageLengthOnDisk, boolean singleWriter) {
        this.maxLen += (long)pageLengthOnDisk;
        ++this.pageCount;
        this.maxLenLive += (long)pageLengthOnDisk;
        ++this.pageCountLive;
        if (singleWriter) {
            ++this.pinCount;
        }
    }

    boolean accountForRemovedPage(int pageLength, boolean pinned, long now, long version) {
        assert (this.isSaved()) : this;
        this.maxLenLive -= (long)pageLength;
        --this.pageCountLive;
        if (pinned) {
            --this.pinCount;
        }
        if (this.unusedAtVersion < version) {
            this.unusedAtVersion = version;
        }
        assert (this.pinCount >= 0) : this;
        assert (this.pageCountLive >= 0) : this;
        assert (this.pinCount <= this.pageCountLive) : this;
        assert (this.maxLenLive >= 0L) : this;
        assert (this.pageCountLive == 0 == (this.maxLenLive == 0L)) : this;
        if (!this.isLive()) {
            assert (this.isEvacuatable()) : this;
            this.unused = now;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.asString();
    }

    public static final class PositionComparator
    implements Comparator<Chunk> {
        public static final Comparator<Chunk> INSTANCE = new PositionComparator();

        private PositionComparator() {
        }

        @Override
        public int compare(Chunk one, Chunk two) {
            return Long.compare(one.block, two.block);
        }
    }
}

