/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.h2.mvstore.MVStoreTool;
import org.h2.store.fs.FilePath;

public class Recovery {
    public static void recover(String fileName) {
        StringWriter messages = new StringWriter();
        try {
            PrintWriter pw = new PrintWriter(messages);
            boolean success = false;
            for (long version = Long.MAX_VALUE; version >= 0L; --version) {
                pw.println((String)(version == Long.MAX_VALUE ? "Trying latest version" : "Trying version " + version));
                pw.flush();
                version = MVStoreTool.rollback((String)fileName, (long)version, (Writer)messages);
                try {
                    String error = MVStoreTool.info((String)(fileName + ".temp"), (Writer)messages);
                    if (error == null) {
                        FilePath.get((String)fileName).moveTo(FilePath.get((String)(fileName + ".back")), true);
                        FilePath.get((String)(fileName + ".temp")).moveTo(FilePath.get((String)fileName), true);
                        pw.println("Success");
                        success = true;
                        break;
                    }
                    pw.println("... failed: " + error);
                    continue;
                }
                catch (Exception e) {
                    pw.println("Fail: " + e.getMessage());
                    pw.flush();
                }
            }
            pw.flush();
            pw.close();
            if (!success) {
                throw new NitriteIOException("Failed to repair database with log: " + messages);
            }
        }
        catch (NitriteIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NitriteIOException("Failed to repair database with log: " + messages, (Throwable)e);
        }
    }
}

