/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.util.AbstractReverseSeekingIterator;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.TableIterator;

public class InternalTableIterator
extends AbstractReverseSeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private final TableIterator tableIterator;

    public InternalTableIterator(TableIterator tableIterator) {
        this.tableIterator = tableIterator;
    }

    @Override
    protected void seekToFirstInternal() {
        this.tableIterator.seekToFirst();
    }

    @Override
    protected void seekToLastInternal() {
        this.tableIterator.seekToLast();
    }

    @Override
    public void seekInternal(InternalKey targetKey) {
        this.tableIterator.seek(targetKey.encode());
    }

    @Override
    public void seekToEndInternal() {
        this.tableIterator.seekToEnd();
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getNextElement() {
        if (this.tableIterator.hasNext()) {
            Object next = this.tableIterator.next();
            return Maps.immutableEntry((Object)new InternalKey((Slice)next.getKey()), next.getValue());
        }
        return null;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getPrevElement() {
        if (this.tableIterator.hasPrev()) {
            Object prev = this.tableIterator.prev();
            return Maps.immutableEntry((Object)new InternalKey((Slice)prev.getKey()), prev.getValue());
        }
        return null;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> peekInternal() {
        if (this.tableIterator.hasNext()) {
            Object peek = this.tableIterator.peek();
            return Maps.immutableEntry((Object)new InternalKey((Slice)peek.getKey()), peek.getValue());
        }
        return null;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> peekPrevInternal() {
        if (this.tableIterator.hasPrev()) {
            Object peekPrev = this.tableIterator.peekPrev();
            return Maps.immutableEntry((Object)new InternalKey((Slice)peekPrev.getKey()), peekPrev.getValue());
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InternalTableIterator");
        sb.append("{fromIterator=").append(this.tableIterator);
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected boolean hasNextInternal() {
        return this.tableIterator.hasNext();
    }

    @Override
    protected boolean hasPrevInternal() {
        return this.tableIterator.hasPrev();
    }
}

