/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.resources.utils;

import org.deeplearning4j.common.resources.DL4JResources;
import org.eclipse.deeplearning4j.resources.utils.EMnistSet;

public class EMnistResourceConstants {
    public static String getTrainingFilesURL(EMnistSet ds) {
        return DL4JResources.getURLString("datasets/emnist/" + EMnistResourceConstants.getImagesFileName(ds, true));
    }

    public static String getTrainingFilesMD5(EMnistSet ds) {
        switch (ds) {
            case COMPLETE: {
                return "712dda0bd6f00690f32236ae4325c377";
            }
            case MERGE: {
                return "4a792d4df261d7e1ba27979573bf53f3";
            }
            case BALANCED: {
                return "4041b0d6f15785d3fa35263901b5496b";
            }
            case LETTERS: {
                return "8795078f199c478165fe18db82625747";
            }
            case DIGITS: {
                return "d2662ecdc47895a6bbfce25de9e9a677";
            }
            case MNIST: {
                return "3663598a39195d030895b6304abb5065";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)ds));
    }

    public static String getTrainingFilesFilename(EMnistSet ds) {
        return EMnistResourceConstants.getImagesFileName(ds, true);
    }

    public static String getTrainingFilesFilename_unzipped(EMnistSet ds) {
        return EMnistResourceConstants.getImagesFileNameUnzipped(ds, true);
    }

    public static String getTrainingFileLabelsURL(EMnistSet ds) {
        return DL4JResources.getURLString("datasets/emnist/" + EMnistResourceConstants.getLabelsFileName(ds, true));
    }

    public static String getTrainingFileLabelsMD5(EMnistSet ds) {
        switch (ds) {
            case COMPLETE: {
                return "ee299a3ee5faf5c31e9406763eae7e43";
            }
            case MERGE: {
                return "491be69ef99e1ab1f5b7f9ccc908bb26";
            }
            case BALANCED: {
                return "7a35cc7b2b7ee7671eddf028570fbd20";
            }
            case LETTERS: {
                return "c16de4f1848ddcdddd39ab65d2a7be52";
            }
            case DIGITS: {
                return "2223fcfee618ac9c89ef20b6e48bcf9e";
            }
            case MNIST: {
                return "6c092f03c9bb63e678f80f8bc605fe37";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)ds));
    }

    public static String getTrainingFileLabelsFilename(EMnistSet ds) {
        return EMnistResourceConstants.getLabelsFileName(ds, true);
    }

    public static String getTrainingFileLabelsFilename_unzipped(EMnistSet ds) {
        return EMnistResourceConstants.getLabelsFileNameUnzipped(ds, true);
    }

    public static String getTestFilesURL(EMnistSet ds) {
        return DL4JResources.getURLString("datasets/emnist/" + EMnistResourceConstants.getImagesFileName(ds, false));
    }

    public static String getTestFilesMD5(EMnistSet ds) {
        switch (ds) {
            case COMPLETE: {
                return "1435209e34070a9002867a9ab50160d7";
            }
            case MERGE: {
                return "8eb5d34c91f1759a55831c37ec2a283f";
            }
            case BALANCED: {
                return "6818d20fe2ce1880476f747bbc80b22b";
            }
            case LETTERS: {
                return "382093a19703f68edac6d01b8dfdfcad";
            }
            case DIGITS: {
                return "a159b8b3bd6ab4ed4793c1cb71a2f5cc";
            }
            case MNIST: {
                return "fb51b6430fc4dd67deaada1bf25d4524";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)ds));
    }

    public static String getTestFilesFilename(EMnistSet ds) {
        return EMnistResourceConstants.getImagesFileName(ds, false);
    }

    public static String getTestFilesFilename_unzipped(EMnistSet ds) {
        return EMnistResourceConstants.getImagesFileNameUnzipped(ds, false);
    }

    public static String getTestFileLabelsURL(EMnistSet ds) {
        return DL4JResources.getURLString("datasets/emnist/" + EMnistResourceConstants.getLabelsFileName(ds, false));
    }

    public static String getTestFileLabelsMD5(EMnistSet ds) {
        switch (ds) {
            case COMPLETE: {
                return "7a0f934bd176c798ecba96b36fda6657";
            }
            case MERGE: {
                return "c13f4cd5211cdba1b8fa992dae2be992";
            }
            case BALANCED: {
                return "acd3694070dcbf620e36670519d4b32f";
            }
            case LETTERS: {
                return "d4108920cd86601ec7689a97f2de7f59";
            }
            case DIGITS: {
                return "8afde66ea51d865689083ba6bb779fac";
            }
            case MNIST: {
                return "ae7f6be798a9a5d5f2bd32e078a402dd";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)ds));
    }

    public static String getTestFileLabelsFilename(EMnistSet ds) {
        return EMnistResourceConstants.getLabelsFileName(ds, false);
    }

    public static String getTestFileLabelsFilename_unzipped(EMnistSet ds) {
        return EMnistResourceConstants.getLabelsFileNameUnzipped(ds, false);
    }

    public static String getImagesFileName(EMnistSet ds, boolean train) {
        return "emnist-" + EMnistResourceConstants.name(ds) + "-" + (train ? "train" : "test") + "-images-idx3-ubyte.gz";
    }

    public static String getImagesFileNameUnzipped(EMnistSet ds, boolean train) {
        return "emnist-" + EMnistResourceConstants.name(ds) + "-" + (train ? "train" : "test") + "-images-idx3-ubyte";
    }

    public static String getLabelsFileName(EMnistSet ds, boolean train) {
        return "emnist-" + EMnistResourceConstants.name(ds) + "-" + (train ? "train" : "test") + "-labels-idx1-ubyte.gz";
    }

    public static String getLabelsFileNameUnzipped(EMnistSet ds, boolean train) {
        return "emnist-" + EMnistResourceConstants.name(ds) + "-" + (train ? "train" : "test") + "-labels-idx1-ubyte";
    }

    public static String getMappingFileName(EMnistSet ds, boolean train) {
        return "emnist-" + EMnistResourceConstants.name(ds) + "-mapping.txt";
    }

    public static String name(EMnistSet ds) {
        switch (ds) {
            case COMPLETE: {
                return "byclass";
            }
            case MERGE: {
                return "bymerge";
            }
            case BALANCED: {
                return "balanced";
            }
            case LETTERS: {
                return "letters";
            }
            case DIGITS: {
                return "digits";
            }
            case MNIST: {
                return "mnist";
            }
        }
        throw new UnsupportedOperationException("Unknown DataSet: " + (Object)((Object)ds));
    }
}

