/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.ui.components.chart.Chart;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChartStackedArea
extends Chart {
    public static final String COMPONENT_TYPE = "ChartStackedArea";
    private double[] x = new double[0];
    private List<double[]> y = new ArrayList<double[]>();
    private List<String> labels = new ArrayList<String>();

    public ChartStackedArea() {
        super(COMPONENT_TYPE);
    }

    public ChartStackedArea(Builder builder) {
        super(COMPONENT_TYPE, builder);
        this.x = builder.x;
        this.y = builder.y;
        this.labels = builder.seriesNames;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChartStackedArea(x=");
        if (this.x != null) {
            sb.append(Arrays.toString(this.x));
        } else {
            sb.append("[]");
        }
        sb.append(",y=[");
        boolean first = true;
        if (this.y != null) {
            for (double[] d : this.y) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(Arrays.toString(d));
                first = false;
            }
        }
        sb.append("],labels=");
        if (this.labels != null) {
            sb.append(this.labels);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartStackedArea)) {
            return false;
        }
        ChartStackedArea other = (ChartStackedArea)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getX(), other.getX())) {
            return false;
        }
        List<double[]> this$y = this.getY();
        List<double[]> other$y = other.getY();
        if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChartStackedArea;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getX());
        List<double[]> $y = this.getY();
        result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }

    public double[] getX() {
        return this.x;
    }

    public List<double[]> getY() {
        return this.y;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public void setY(List<double[]> y) {
        this.y = y;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public static class Builder
    extends Chart.Builder<Builder> {
        private double[] x;
        private List<double[]> y = new ArrayList<double[]>();
        private List<String> seriesNames = new ArrayList<String>();

        public Builder(String title, StyleChart style) {
            super(title, style);
        }

        public Builder setXValues(double[] x) {
            this.x = x;
            return this;
        }

        public Builder addSeries(String seriesName, double[] yValues) {
            this.y.add(yValues);
            this.seriesNames.add(seriesName);
            return this;
        }

        public ChartStackedArea build() {
            return new ChartStackedArea(this);
        }
    }
}

