/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class ZeroPaddingLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer> {
    public ZeroPaddingLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        long[] inShape = this.input.shape();
        boolean nchw = ((org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer)this.layerConf()).getDataFormat() == CNN2DFormat.NCHW;
        int hIdx = nchw ? 2 : 1;
        int wIdx = nchw ? 3 : 2;
        int[] padding = ((org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer)this.layerConf()).getPadding();
        INDArray epsNext = ((org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer)this.layerConf()).getDataFormat() == CNN2DFormat.NCHW ? epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)padding[0], (long)((long)padding[0] + inShape[hIdx])), NDArrayIndex.interval((long)padding[2], (long)((long)padding[2] + inShape[wIdx]))}) : epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)padding[0], (long)((long)padding[0] + inShape[hIdx])), NDArrayIndex.interval((long)padding[2], (long)((long)padding[2] + inShape[wIdx])), NDArrayIndex.all()});
        epsNext = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsNext);
        return new Pair((Object)new DefaultGradient(), (Object)epsNext);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        this.assertInputSet(false);
        boolean nchw = ((org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer)this.layerConf()).getDataFormat() == CNN2DFormat.NCHW;
        int hIdx = nchw ? 2 : 1;
        int wIdx = nchw ? 3 : 2;
        int[] padding = ((org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer)this.layerConf()).getPadding();
        long[] inShape = this.input.shape();
        long outH = inShape[hIdx] + (long)padding[0] + (long)padding[1];
        long outW = inShape[wIdx] + (long)padding[2] + (long)padding[3];
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = inShape[0];
            lArray2[1] = inShape[1];
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = inShape[0];
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = inShape[3];
        }
        long[] outShape = lArray;
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        if (nchw) {
            out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)padding[0], (long)((long)padding[0] + inShape[hIdx])), NDArrayIndex.interval((long)padding[2], (long)((long)padding[2] + inShape[wIdx]))}, this.input);
        } else {
            out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)padding[0], (long)((long)padding[0] + inShape[hIdx])), NDArrayIndex.interval((long)padding[2], (long)((long)padding[2] + inShape[wIdx])), NDArrayIndex.all()}, this.input);
        }
        return out;
    }

    public Layer clone() {
        return new ZeroPaddingLayer(this.conf.clone(), this.dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }
}

