/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.convolution.DepthwiseConvolution2DLayer;
import org.deeplearning4j.nn.params.DepthwiseConvolutionParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DepthwiseConvolution2D
extends ConvolutionLayer {
    protected int depthMultiplier;

    protected DepthwiseConvolution2D(Builder builder) {
        super(builder);
        Preconditions.checkState((builder.depthMultiplier > 0 ? 1 : 0) != 0, (String)"Depth multiplier must be > 0,  got %s", (int)builder.depthMultiplier);
        this.depthMultiplier = builder.depthMultiplier;
        this.nOut = this.nIn * (long)this.depthMultiplier;
        this.cnn2dDataFormat = builder.cnn2DFormat;
        this.initializeConstraints(builder);
    }

    @Override
    public DepthwiseConvolution2D clone() {
        DepthwiseConvolution2D clone = (DepthwiseConvolution2D)super.clone();
        clone.depthMultiplier = this.depthMultiplier;
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("DepthwiseConvolution2D", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        DepthwiseConvolution2DLayer ret = new DepthwiseConvolution2DLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return DepthwiseConvolutionParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for  depth-wise convolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), this.cnn2dDataFormat, DepthwiseConvolution2DLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        super.setNIn(inputType, override);
        if (this.nOut == 0L || override) {
            this.nOut = this.nIn * (long)this.depthMultiplier;
        }
        this.cnn2dDataFormat = ((InputType.InputTypeConvolutional)inputType).getFormat();
    }

    public int getDepthMultiplier() {
        return this.depthMultiplier;
    }

    public void setDepthMultiplier(int depthMultiplier) {
        this.depthMultiplier = depthMultiplier;
    }

    public DepthwiseConvolution2D() {
    }

    @Override
    public String toString() {
        return "DepthwiseConvolution2D(super=" + super.toString() + ", depthMultiplier=" + this.getDepthMultiplier() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepthwiseConvolution2D)) {
            return false;
        }
        DepthwiseConvolution2D other = (DepthwiseConvolution2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getDepthMultiplier() == other.getDepthMultiplier();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepthwiseConvolution2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDepthMultiplier();
        return result;
    }

    public static class Builder
    extends ConvolutionLayer.BaseConvBuilder<Builder> {
        protected int depthMultiplier = 1;
        protected CNN2DFormat cnn2DFormat = CNN2DFormat.NCHW;

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder() {
        }

        @Override
        protected boolean allowCausal() {
            return false;
        }

        public Builder dataFormat(CNN2DFormat format) {
            this.cnn2DFormat = format;
            return this;
        }

        public Builder depthMultiplier(int depthMultiplier) {
            this.setDepthMultiplier(depthMultiplier);
            return this;
        }

        @Override
        public Builder kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        @Override
        public Builder stride(int ... stride) {
            this.setStride(stride);
            return this;
        }

        @Override
        public Builder padding(int ... padding) {
            this.setPadding(padding);
            return this;
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize = ValidationUtils.validate2NonNegative(kernelSize, false, "kernelSize");
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ValidationUtils.validate2NonNegative(stride, false, "stride");
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate2NonNegative(padding, false, "padding");
        }

        @Override
        public void setDilation(int ... dilation) {
            this.dilation = ValidationUtils.validate2NonNegative(dilation, false, "dilation");
        }

        @Override
        public DepthwiseConvolution2D build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new DepthwiseConvolution2D(this);
        }

        public int getDepthMultiplier() {
            return this.depthMultiplier;
        }

        public CNN2DFormat getCnn2DFormat() {
            return this.cnn2DFormat;
        }

        public void setDepthMultiplier(int depthMultiplier) {
            this.depthMultiplier = depthMultiplier;
        }

        public void setCnn2DFormat(CNN2DFormat cnn2DFormat) {
            this.cnn2DFormat = cnn2DFormat;
        }
    }
}

