/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.Serializable;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.BaseTrainingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreIterationListener
extends BaseTrainingListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ScoreIterationListener.class);
    private int printIterations = 10;

    public ScoreIterationListener(int printIterations) {
        this.printIterations = printIterations;
    }

    public ScoreIterationListener() {
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        if (this.printIterations <= 0) {
            this.printIterations = 1;
        }
        if (iteration % this.printIterations == 0) {
            double score = model.score();
            log.info("Score at iteration {} is {}", (Object)iteration, (Object)score);
        }
    }

    public String toString() {
        return "ScoreIterationListener(" + this.printIterations + ")";
    }
}

