/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;

public class FeedForwardToRnnPreProcessor
implements InputPreProcessor {
    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (input.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., activations for FF layer)");
        }
        if (input.ordering() != 'f' || !Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = workspaceMgr.dup(ArrayType.ACTIVATIONS, input, 'f');
        }
        long[] shape = input.shape();
        INDArray reshaped = input.reshape('f', new long[]{miniBatchSize, shape[0] / (long)miniBatchSize, shape[1]});
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, reshaped.permute(new int[]{0, 2, 1}));
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        INDArray ret;
        long[] shape;
        if (output.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., epsilons from RNN layer)");
        }
        if (output.ordering() != 'f' || !Shape.hasDefaultStridesForShape((INDArray)output)) {
            output = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, output, 'f');
        }
        if ((shape = output.shape())[0] == 1L) {
            ret = output.tensorAlongDimension(0L, new int[]{1, 2}).permutei(new int[]{1, 0});
        } else {
            if (shape[2] == 1L) {
                return output.tensorAlongDimension(0L, new int[]{1, 0});
            }
            INDArray permuted = output.permute(new int[]{0, 2, 1});
            ret = permuted.reshape('f', new long[]{shape[0] * shape[2], shape[1]});
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, ret);
    }

    @Override
    public FeedForwardToRnnPreProcessor clone() {
        try {
            FeedForwardToRnnPreProcessor clone = (FeedForwardToRnnPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.FF && inputType.getType() != InputType.Type.CNNFlat) {
            throw new IllegalStateException("Invalid input: expected input of type FeedForward, got " + inputType);
        }
        if (inputType.getType() == InputType.Type.FF) {
            InputType.InputTypeFeedForward ff = (InputType.InputTypeFeedForward)inputType;
            return InputType.recurrent(ff.getSize());
        }
        InputType.InputTypeConvolutionalFlat cf = (InputType.InputTypeConvolutionalFlat)inputType;
        return InputType.recurrent(cf.getFlattenedSize());
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        if (maskArray.isVector()) {
            return new Pair((Object)TimeSeriesUtils.reshapeVectorToTimeSeriesMask(maskArray, minibatchSize), (Object)currentMaskState);
        }
        throw new IllegalArgumentException("Received mask array with shape " + Arrays.toString(maskArray.shape()) + "; expected vector.");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToRnnPreProcessor)) {
            return false;
        }
        FeedForwardToRnnPreProcessor other = (FeedForwardToRnnPreProcessor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToRnnPreProcessor;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "FeedForwardToRnnPreProcessor()";
    }
}

