/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights;

import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.impl.OrthogonalDistribution;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class WeightInitDistribution
implements IWeightInit {
    private final Distribution distribution;

    public WeightInitDistribution(@JsonProperty(value="distribution") Distribution distribution) {
        if (distribution == null) {
            throw new IllegalArgumentException("Must set distribution!");
        }
        this.distribution = distribution;
    }

    @Override
    public INDArray init(double fanIn, double fanOut, long[] shape, char order, INDArray paramView) {
        org.nd4j.linalg.api.rng.distribution.Distribution dist = Distributions.createDistribution(this.distribution);
        if (dist instanceof OrthogonalDistribution) {
            dist.sample(paramView.reshape(order, shape));
        } else {
            dist.sample(paramView);
        }
        return paramView.reshape(order, shape);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightInitDistribution)) {
            return false;
        }
        WeightInitDistribution other = (WeightInitDistribution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Distribution this$distribution = this.distribution;
        Distribution other$distribution = other.distribution;
        return !(this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightInitDistribution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Distribution $distribution = this.distribution;
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        return result;
    }
}

