/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.mkldnn;

import java.util.Collections;
import java.util.Map;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.mkldnn.BaseMKLDNNHelper;
import org.deeplearning4j.nn.layers.normalization.LocalResponseNormalizationHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalization;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class MKLDNNLocalResponseNormalizationHelper
extends BaseMKLDNNHelper
implements LocalResponseNormalizationHelper {
    protected OpContext context;

    public MKLDNNLocalResponseNormalizationHelper(DataType dataType) {
    }

    @Override
    public boolean checkSupported(double k, double n, double alpha, double beta) {
        return BaseMKLDNNHelper.mklDnnEnabled();
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray input, INDArray epsilon, double k, double n, double alpha, double beta, LayerWorkspaceMgr workspaceMgr) {
        INDArray gradAtInput = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, input.dataType(), input.shape());
        if (this.context == null) {
            this.context = Nd4j.getExecutioner().buildContext();
            this.context.setTArguments(new double[]{k, alpha, beta});
            this.context.setIArguments(new long[]{(int)n});
        }
        LocalResponseNormalization op = new LocalResponseNormalization();
        this.context.setInputArray(0, input);
        this.context.setInputArray(0, epsilon);
        this.context.setOutputArray(0, gradAtInput);
        Nd4j.exec((CustomOp)op, (OpContext)this.context);
        DefaultGradient g = new DefaultGradient();
        return new Pair((Object)g, (Object)gradAtInput);
    }

    @Override
    public INDArray activate(INDArray x, boolean training, double k, double n, double alpha, double beta, LayerWorkspaceMgr workspaceMgr) {
        INDArray out = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, x.dataType(), x.shape());
        if (this.context == null) {
            this.context = Nd4j.getExecutioner().buildContext();
            this.context.setTArguments(new double[]{k, alpha, beta});
            this.context.setIArguments(new long[]{(int)n});
        }
        this.context.setInputArray(0, x);
        this.context.setOutputArray(0, out);
        LocalResponseNormalization op = new LocalResponseNormalization();
        Nd4j.exec((CustomOp)op, (OpContext)this.context);
        return out;
    }

    @Override
    public Map<String, Long> helperMemoryUse() {
        return Collections.emptyMap();
    }
}

