/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.elementwise;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public class ElementWiseMultiplicationLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer> {
    public ElementWiseMultiplicationLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray z = this.preOutput(true, workspaceMgr);
        INDArray delta = (INDArray)((org.deeplearning4j.nn.conf.layers.misc.ElementWiseMultiplicationLayer)this.layerConf()).getActivationFn().backprop(z, epsilon).getFirst();
        if (this.maskArray != null) {
            this.applyMask(delta);
        }
        INDArray input = this.input.castTo(this.dataType);
        DefaultGradient ret = new DefaultGradient();
        INDArray weightGrad = (INDArray)this.gradientViews.get("W");
        weightGrad.subi(weightGrad);
        weightGrad.addi(input.mul(delta).sum(new int[]{0}));
        INDArray biasGrad = (INDArray)this.gradientViews.get("b");
        delta.sum(biasGrad, new int[]{0});
        ret.gradientForVariable().put("W", weightGrad);
        ret.gradientForVariable().put("b", biasGrad);
        INDArray epsilonNext = delta.mulRowVector((INDArray)this.params.get("W"));
        epsilonNext = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsilonNext);
        epsilonNext = this.backpropDropOutIfPresent(epsilonNext);
        return new Pair((Object)ret, (Object)epsilonNext);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public INDArray preOutput(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray b = this.getParam("b");
        INDArray W = this.getParam("W");
        if (this.input.columns() != W.columns()) {
            throw new DL4JInvalidInputException("Input size (" + this.input.columns() + " columns; shape = " + Arrays.toString(this.input.shape()) + ") is invalid: does not match layer input size (layer # inputs = " + W.shapeInfoToString() + ") " + this.layerId());
        }
        INDArray input = this.input.castTo(this.dataType);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray ret = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, input.dataType(), input.shape(), 'c');
        ret.assign(input.mulRowVector(W).addiRowVector(b));
        if (this.maskArray != null) {
            this.applyMask(ret);
        }
        return ret;
    }
}

