/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.primitives.Pair;

public class Convolution1DLayer
extends ConvolutionLayer {
    public Convolution1DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        if (epsilon.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + epsilon.rank() + " array as epsilon for Convolution1DLayer backprop with shape " + Arrays.toString(epsilon.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length]. " + this.layerId());
        }
        if (this.maskArray != null) {
            INDArray maskOut = (INDArray)this.feedForwardMaskArray(this.maskArray, MaskState.Active, (int)epsilon.size(0)).getFirst();
            Preconditions.checkState((epsilon.size(0) == maskOut.size(0) && epsilon.size(2) == maskOut.size(1) ? 1 : 0) != 0, (String)"Activation gradients dimensions (0,2) and mask dimensions (0,1) don't match: Activation gradients %s, Mask %s", (Object)epsilon.shape(), (Object)maskOut.shape());
            Broadcast.mul((INDArray)epsilon, (INDArray)maskOut, (INDArray)epsilon, (int[])new int[]{0, 2});
        }
        epsilon = epsilon.reshape(new long[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1L});
        INDArray origInput = this.input;
        this.input = this.input.reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        Pair<Gradient, INDArray> gradientEpsNext = super.backpropGradient(epsilon, workspaceMgr);
        INDArray epsNext = (INDArray)gradientEpsNext.getSecond();
        epsNext = epsNext.reshape(new long[]{epsNext.size(0), epsNext.size(1), epsNext.size(2)});
        this.input = origInput;
        return new Pair(gradientEpsNext.getFirst(), (Object)epsNext);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput4d(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        Pair<INDArray, INDArray> preOutput = super.preOutput(true, forBackprop, workspaceMgr);
        INDArray p3d = (INDArray)preOutput.getFirst();
        INDArray p = ((INDArray)preOutput.getFirst()).reshape(new long[]{p3d.size(0), p3d.size(1), p3d.size(2), 1L});
        preOutput.setFirst((Object)p);
        return preOutput;
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        INDArray origInput = this.input;
        this.input = this.input.reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        Pair<INDArray, INDArray> preOutput = super.preOutput(training, forBackprop, workspaceMgr);
        this.input = origInput;
        INDArray p4d = (INDArray)preOutput.getFirst();
        INDArray p = ((INDArray)preOutput.getFirst()).reshape(new long[]{p4d.size(0), p4d.size(1), p4d.size(2)});
        preOutput.setFirst((Object)p);
        return preOutput;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray act4d = super.activate(training, workspaceMgr);
        INDArray act3d = act4d.reshape(new long[]{act4d.size(0), act4d.size(1), act4d.size(2)});
        if (this.maskArray != null) {
            INDArray maskOut = (INDArray)this.feedForwardMaskArray(this.maskArray, MaskState.Active, (int)act3d.size(0)).getFirst();
            Preconditions.checkState((act3d.size(0) == maskOut.size(0) && act3d.size(2) == maskOut.size(1) ? 1 : 0) != 0, (String)"Activations dimensions (0,2) and mask dimensions (0,1) don't match: Activations %s, Mask %s", (Object)act3d.shape(), (Object)maskOut.shape());
            Broadcast.mul((INDArray)act3d, (INDArray)maskOut, (INDArray)act3d, (int[])new int[]{0, 2});
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, act3d);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        INDArray reduced = ConvolutionUtils.cnn1dMaskReduction(maskArray, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize()[0], ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride()[0], ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding()[0], ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation()[0], ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getConvolutionMode());
        return new Pair((Object)reduced, (Object)currentMaskState);
    }
}

