/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.weights;

import org.deeplearning4j.nn.weights.IWeightInit;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.random.impl.TruncatedNormalDistribution;
import org.nd4j.linalg.factory.Nd4j;

public class WeightInitVarScalingNormalFanAvg
implements IWeightInit {
    private Double scale;

    public WeightInitVarScalingNormalFanAvg(Double scale) {
        this.scale = scale;
    }

    @Override
    public INDArray init(double fanIn, double fanOut, long[] shape, char order, INDArray paramView) {
        double std = this.scale == null ? Math.sqrt(2.0 / (fanIn + fanOut)) : Math.sqrt(2.0 * this.scale / (fanIn + fanOut));
        Nd4j.exec((Op)new TruncatedNormalDistribution(paramView, 0.0, std));
        return paramView.reshape(order, shape);
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightInitVarScalingNormalFanAvg)) {
            return false;
        }
        WeightInitVarScalingNormalFanAvg other = (WeightInitVarScalingNormalFanAvg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$scale = this.getScale();
        Double other$scale = other.getScale();
        return !(this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightInitVarScalingNormalFanAvg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        return result;
    }

    public String toString() {
        return "WeightInitVarScalingNormalFanAvg(scale=" + this.getScale() + ")";
    }

    public WeightInitVarScalingNormalFanAvg() {
    }
}

