/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import java.util.concurrent.TimeUnit;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MaxTimeIterationTerminationCondition
implements IterationTerminationCondition {
    private long maxTimeAmount;
    private TimeUnit maxTimeUnit;
    private long initializationTime;
    private long endTime;

    public MaxTimeIterationTerminationCondition(@JsonProperty(value="maxTimeAmount") long maxTimeAmount, @JsonProperty(value="maxTimeUnit") TimeUnit maxTimeUnit) {
        if (maxTimeAmount <= 0L || maxTimeUnit == null) {
            throw new IllegalArgumentException("Invalid maximum training time: amount = " + maxTimeAmount + " unit = " + maxTimeUnit);
        }
        this.maxTimeAmount = maxTimeAmount;
        this.maxTimeUnit = maxTimeUnit;
    }

    @Override
    public void initialize() {
        this.initializationTime = System.currentTimeMillis();
        this.endTime = this.initializationTime + this.maxTimeUnit.toMillis(this.maxTimeAmount);
    }

    @Override
    public boolean terminate(double lastMiniBatchScore) {
        return System.currentTimeMillis() >= this.endTime;
    }

    public String toString() {
        return "MaxTimeIterationTerminationCondition(" + this.maxTimeAmount + ",unit=" + this.maxTimeUnit + ")";
    }

    public long getMaxTimeAmount() {
        return this.maxTimeAmount;
    }

    public TimeUnit getMaxTimeUnit() {
        return this.maxTimeUnit;
    }

    public long getInitializationTime() {
        return this.initializationTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setMaxTimeAmount(long maxTimeAmount) {
        this.maxTimeAmount = maxTimeAmount;
    }

    public void setMaxTimeUnit(TimeUnit maxTimeUnit) {
        this.maxTimeUnit = maxTimeUnit;
    }

    public void setInitializationTime(long initializationTime) {
        this.initializationTime = initializationTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxTimeIterationTerminationCondition)) {
            return false;
        }
        MaxTimeIterationTerminationCondition other = (MaxTimeIterationTerminationCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxTimeAmount() != other.getMaxTimeAmount()) {
            return false;
        }
        if (this.getInitializationTime() != other.getInitializationTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        TimeUnit this$maxTimeUnit = this.getMaxTimeUnit();
        TimeUnit other$maxTimeUnit = other.getMaxTimeUnit();
        return !(this$maxTimeUnit == null ? other$maxTimeUnit != null : !((Object)((Object)this$maxTimeUnit)).equals((Object)other$maxTimeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaxTimeIterationTerminationCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxTimeAmount = this.getMaxTimeAmount();
        result = result * 59 + (int)($maxTimeAmount >>> 32 ^ $maxTimeAmount);
        long $initializationTime = this.getInitializationTime();
        result = result * 59 + (int)($initializationTime >>> 32 ^ $initializationTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        TimeUnit $maxTimeUnit = this.getMaxTimeUnit();
        result = result * 59 + ($maxTimeUnit == null ? 43 : ((Object)((Object)$maxTimeUnit)).hashCode());
        return result;
    }
}

